/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.util;

import elucent.elulib.ELEvents;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class RenderUtil {
    public static ResourceLocation beam_texture = new ResourceLocation("elulib:textures/effect/beam.png");
    public static ResourceLocation glow_texture = new ResourceLocation("elulib:textures/effect/glow.png");
    public static int maxLightX = 0xF000F0;
    public static int maxLightY = 0xF000F0;

    public static void renderBeam(BufferBuilder buf, double x1, double y1, double z1, double x2, double y2, double z2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, double width) {
        float yaw = (float)Math.atan2(x2 - x1, z2 - z1);
        float pitch = (float)Math.atan2(y2 - y1, MathHelper.func_76133_a((double)(Math.pow(x2 - x1, 2.0) + Math.pow(z2 - z1, 2.0))));
        double tX1 = width * (double)MathHelper.func_76134_b((float)yaw);
        double tY1 = 0.0;
        double tZ1 = -width * (double)MathHelper.func_76126_a((float)yaw);
        double tX2 = width * (double)MathHelper.func_76126_a((float)yaw) * -((double)MathHelper.func_76126_a((float)pitch));
        double tY2 = width * (double)MathHelper.func_76134_b((float)pitch);
        double tZ2 = width * (double)MathHelper.func_76134_b((float)yaw) * -((double)MathHelper.func_76126_a((float)pitch));
        buf.func_181662_b(x1 - tX1, y1 - tY1, z1 - tZ1).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tX1, y2 - tY1, z2 - tZ1).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tX1, y2 + tY1, z2 + tZ1).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tX1, y1 + tY1, z1 + tZ1).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x1 - tX2, y1 - tY2, z1 - tZ2).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tX2, y2 - tY2, z2 - tZ2).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tX2, y2 + tY2, z2 + tZ2).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tX2, y1 + tY2, z1 + tZ2).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
    }

    public static void renderBeam(BufferBuilder buf, double x1, double y1, double z1, double x2, double y2, double z2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, double width, double angle) {
        float rads = (float)Math.toRadians(angle);
        double ac = MathHelper.func_76134_b((float)rads);
        double as = MathHelper.func_76126_a((float)rads);
        float yaw = (float)Math.atan2(x2 - x1, z2 - z1);
        float pitch = (float)Math.atan2(y2 - y1, MathHelper.func_76133_a((double)(Math.pow(x2 - x1, 2.0) + Math.pow(z2 - z1, 2.0))));
        double tX1 = width * (double)MathHelper.func_76134_b((float)yaw);
        double tY1 = 0.0;
        double tZ1 = -width * (double)MathHelper.func_76126_a((float)yaw);
        double tX2 = width * (double)MathHelper.func_76126_a((float)yaw) * -((double)MathHelper.func_76126_a((float)pitch));
        double tY2 = width * (double)MathHelper.func_76134_b((float)pitch);
        double tZ2 = width * (double)MathHelper.func_76134_b((float)yaw) * -((double)MathHelper.func_76126_a((float)pitch));
        double tXc = tX1 * ac + tX2 * as;
        double tYc = tY1 * ac + tY2 * as;
        double tZc = tZ1 * ac + tZ2 * as;
        double tXs = tX1 * -as + tX2 * ac;
        double tYs = tY1 * -as + tY2 * ac;
        double tZs = tZ1 * -as + tZ2 * ac;
        buf.func_181662_b(x1 - tXs, y1 - tYs, z1 - tZs).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tXs, y2 - tYs, z2 - tZs).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tXs, y2 + tYs, z2 + tZs).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tXs, y1 + tYs, z1 + tZs).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x1 - tXc, y1 - tYc, z1 - tZc).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tXc, y2 - tYc, z2 - tZc).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tXc, y2 + tYc, z2 + tZc).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tXc, y1 + tYc, z1 + tZc).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
    }

    public static void renderBeamGui(BufferBuilder buf, double x1, double y1, double x2, double y2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, double width) {
        float yaw = (float)Math.atan2(y2 - y1, x2 - x1);
        double tX1 = -width * (double)MathHelper.func_76126_a((float)yaw);
        double tY1 = width * (double)MathHelper.func_76134_b((float)yaw);
        buf.func_181662_b(x1 - tX1, y1 - tY1, 0.0).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tX1, y2 - tY1, 0.0).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tX1, y2 + tY1, 0.0).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tX1, y1 + tY1, 0.0).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
    }

    public static void renderBeamSeriesGui(BufferBuilder buf, double x1, double y1, double x2, double y2, float r1, float g1, float b1, float a1, double width, boolean horiz) {
        float yaw2 = (float)Math.atan2(y2 - y1, x2 - x1);
        double tX1 = width * (double)MathHelper.func_76134_b((float)yaw2);
        double tY1 = -width * (double)MathHelper.func_76126_a((float)yaw2);
        buf.func_181662_b(x1 - tX1, y1 - tY1, 0.0).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x1 + tX1, y1 + tY1, 0.0).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
    }

    public static void renderBeamSeries(BufferBuilder buf, double x1, double y1, double z1, double x2, double y2, double z2, float r1, float g1, float b1, float a1, double width, boolean horiz) {
        float yaw2 = (float)Math.atan2(x2 - x1, z2 - z1);
        float pitch2 = (float)Math.atan2(y2 - y1, MathHelper.func_76133_a((double)(Math.pow(x2 - x1, 2.0) + Math.pow(z2 - z1, 2.0))));
        double tX1 = width * (double)MathHelper.func_76134_b((float)yaw2);
        double tY1 = 0.0;
        double tZ1 = -width * (double)MathHelper.func_76126_a((float)yaw2);
        double tX2 = width * (double)MathHelper.func_76126_a((float)yaw2) * -((double)MathHelper.func_76126_a((float)pitch2));
        double tY2 = width * (double)MathHelper.func_76134_b((float)pitch2);
        double tZ2 = width * (double)MathHelper.func_76134_b((float)yaw2) * -((double)MathHelper.func_76126_a((float)pitch2));
        if (horiz) {
            buf.func_181662_b(x1 - tX1, y1 - tY1, z1 - tZ1).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x1 + tX1, y1 + tY1, z1 + tZ1).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        } else {
            buf.func_181662_b(x1 - tX2, y1 - tY2, z1 - tZ2).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x1 + tX2, y1 + tY2, z1 + tZ2).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        }
    }

    public static void renderSlash(BufferBuilder buf, double x0, double y0, double z0, float r, float g, float b, float a, float radius, float width, float angleRange) {
        for (float i = -angleRange / 2.0f; i < angleRange / 2.0f; i += angleRange / 16.0f) {
            float coeff1 = 1.0f - Math.abs(i) / (angleRange / 2.0f);
            float coeff2 = 1.0f - Math.abs(i + angleRange / 16.0f) / (angleRange / 2.0f);
            double x1 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            double z1 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            double x2 = x0 + (double)(radius + 0.5f * coeff1 * width) * Math.sin(Math.toRadians(i));
            double z2 = z0 + (double)(radius + 0.5f * coeff1 * width) * Math.cos(Math.toRadians(i));
            double x3 = x0 + (double)(radius + 0.5f * coeff2 * width) * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            double z3 = z0 + (double)(radius + 0.5f * coeff2 * width) * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            double x4 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            double z4 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0, z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0, z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            x1 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            z1 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            x2 = x0 + (double)(radius - 0.5f * coeff1 * width) * Math.sin(Math.toRadians(i));
            z2 = z0 + (double)(radius - 0.5f * coeff1 * width) * Math.cos(Math.toRadians(i));
            x3 = x0 + (double)(radius - 0.5f * coeff2 * width) * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z3 = z0 + (double)(radius - 0.5f * coeff2 * width) * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            x4 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z4 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0, z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0, z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0, z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0, z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            x1 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            z1 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            x2 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            z2 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            x3 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z3 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            x4 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z4 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0 - (double)(width * 0.5f * coeff1), z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0 - (double)(width * 0.5f * coeff2), z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0 + (double)(width * 0.5f * coeff1), z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0 + (double)(width * 0.5f * coeff2), z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
        }
    }

    public static void renderBeamSeries(BufferBuilder buf, double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        float yaw1 = (float)Math.atan2(x1 - x0, z1 - z0);
        float pitch1 = (float)Math.atan2(y1 - y0, MathHelper.func_76133_a((double)(Math.pow(x1 - x0, 2.0) + Math.pow(z1 - z0, 2.0))));
        float yaw2 = (float)Math.atan2(x2 - x1, z2 - z1);
        float pitch2 = (float)Math.atan2(y2 - y1, MathHelper.func_76133_a((double)(Math.pow(x2 - x1, 2.0) + Math.pow(z2 - z1, 2.0))));
        double iX1 = 0.2 * (double)MathHelper.func_76134_b((float)yaw1);
        double iY1 = 0.0;
        double iZ1 = -0.2 * (double)MathHelper.func_76126_a((float)yaw1);
        double iX2 = 0.2 * (double)MathHelper.func_76126_a((float)yaw1) * -((double)MathHelper.func_76126_a((float)pitch1));
        double iY2 = 0.2 * (double)MathHelper.func_76134_b((float)pitch1);
        double iZ2 = 0.2 * (double)MathHelper.func_76134_b((float)yaw1) * -((double)MathHelper.func_76126_a((float)pitch1));
        double tX1 = 0.2 * (double)MathHelper.func_76134_b((float)yaw2);
        double tY1 = 0.0;
        double tZ1 = -0.2 * (double)MathHelper.func_76126_a((float)yaw2);
        double tX2 = 0.2 * (double)MathHelper.func_76126_a((float)yaw2) * -((double)MathHelper.func_76126_a((float)pitch2));
        double tY2 = 0.2 * (double)MathHelper.func_76134_b((float)pitch2);
        double tZ2 = 0.2 * (double)MathHelper.func_76134_b((float)yaw2) * -((double)MathHelper.func_76126_a((float)pitch2));
        if (Math.signum(tX1) != Math.signum(iX1) || Math.signum(tY1) != Math.signum(iY1) || Math.signum(tZ1) != Math.signum(iZ1)) {
            buf.func_181662_b(x2 - tX1, y2 - tY1, z2 - tZ1).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buf.func_181662_b(x1 + iX1, y1 + iY1, z1 + iZ1).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x1 - iX1, y1 - iY1, z1 - iZ1).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x2 + tX1, y2 + tY1, z2 + tZ1).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        } else {
            buf.func_181662_b(x1 - iX1, y1 - iY1, z1 - iZ1).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x2 - tX1, y2 - tY1, z2 - tZ1).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buf.func_181662_b(x2 + tX1, y2 + tY1, z2 + tZ1).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buf.func_181662_b(x1 + iX1, y1 + iY1, z1 + iZ1).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        }
        if (Math.signum(tX2) != Math.signum(iX2) || Math.signum(tY2) != Math.signum(iY2) || Math.signum(tZ2) != Math.signum(iZ2)) {
            buf.func_181662_b(x2 - tX2, y2 - tY2, z2 - tZ2).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buf.func_181662_b(x1 + iX2, y1 + iY2, z1 + iZ2).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x1 - iX2, y1 - iY2, z1 - iZ2).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x2 + tX2, y2 + tY2, z2 + tZ2).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        } else {
            buf.func_181662_b(x1 - iX2, y1 - iY2, z1 - iZ2).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buf.func_181662_b(x2 - tX2, y2 - tY2, z2 - tZ2).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buf.func_181662_b(x2 + tX2, y2 + tY2, z2 + tZ2).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buf.func_181662_b(x1 + iX2, y1 + iY2, z1 + iZ2).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        }
    }

    public static void drawTextRGBA(FontRenderer font, String s, int x, int y, int r, int g, int b, int a) {
        font.func_78276_b(s, x, y, (a << 24) + (r << 16) + (g << 8) + b);
    }

    public static void renderStarBurst(BufferBuilder buf, double x, double y, double z, float r, float g, float b, float a, double width, double radius) {
        for (double i = -1.5707963267948966; i <= 1.5707963267948966; i += 0.39269908169872414) {
            for (double j = 0.0; j < Math.PI * 2; j += Math.PI * (0.75 * Math.abs(i / 1.5707963267948966) + 0.25)) {
                double si = (double)((float)ELEvents.ticks / 80.0f) * (0.375 + 0.773 * j / (Math.PI * 2)) * (0.25 + 1.225 * i / Math.PI) * Math.PI * 2.0;
                double sj = (double)((float)ELEvents.ticks / 57.0f) * (0.25 + 1.63 * i / 1.5707963267948966) * (0.375 + 0.241 * j / Math.PI) * Math.PI * 2.0;
                double dx = radius * Math.sin(sj) * Math.cos(si);
                double dy = radius * Math.sin(si);
                double dz = radius * Math.cos(sj) * Math.cos(si);
                RenderUtil.renderBeam(buf, x + dx * 0.25, y + dy * 0.25, z + dz * 0.25, x + dx * 0.375, y + dy * 0.375, z + dz * 0.375, r, g, b, 0.0f, r, g, b, a, width);
                RenderUtil.renderBeam(buf, x + dx * 0.375, y + dy * 0.375, z + dz * 0.375, x + dx, y + dy, z + dz, r, g, b, a, r, g, b, 0.0f, width);
            }
        }
    }

    public static void renderBeamCircle(BufferBuilder buf, double x, double y, double z, float r, float g, float b, float a, double width, double radius, int steps, boolean horiz) {
        for (double i = 0.0; i <= Math.PI * 2; i += Math.PI * (2.0 / (double)steps)) {
            double x1 = x + Math.sin(i) * radius;
            double z1 = z + Math.cos(i) * radius;
            double x2 = x + Math.sin(i + Math.PI * (2.0 / (double)steps)) * radius;
            double z2 = z + Math.cos(i + Math.PI * (2.0 / (double)steps)) * radius;
            RenderUtil.renderBeamSeries(buf, x1, y, z1, x2, y, z2, r, g, b, a, width, horiz);
        }
    }

    public static void drawCrystal(BufferBuilder buf, float x, float y, float z, float r, float g, float b, float a, float rotation, float hsize, float ysize, float minU, float minV, float maxU, float maxV) {
        float offX1 = hsize * 0.5f * (float)Math.sin(Math.toRadians(rotation));
        float offZ1 = hsize * 0.5f * (float)Math.cos(Math.toRadians(rotation));
        float offX2 = hsize * 0.5f * (float)Math.sin(Math.toRadians(rotation + 90.0f));
        float offZ2 = hsize * 0.5f * (float)Math.cos(Math.toRadians(rotation + 90.0f));
        float pos1X = x;
        double pos1Y = y - ysize * 0.5f;
        double pos1Z = z;
        double pos2X = x + offX1;
        double pos2Y = y;
        double pos2Z = z + offZ1;
        double pos3X = x + offX2;
        double pos3Y = y;
        double pos3Z = z + offZ2;
        double pos4X = x - offX1;
        double pos4Y = y;
        double pos4Z = z - offZ1;
        double pos5X = x - offX2;
        double pos5Y = y;
        double pos5Z = z - offZ2;
        double pos6X = x;
        double pos6Y = y + ysize * 0.5f;
        double pos6Z = z;
        Vec3d diff1 = new Vec3d(pos3X - (double)pos1X, pos3Y - pos1Y, pos3Z - pos1Z);
        Vec3d diff2 = new Vec3d(pos2X - (double)pos1X, pos2Y - pos1Y, pos2Z - pos1Z);
        Vec3d normal1 = new Vec3d(diff1.field_72448_b * diff2.field_72449_c - diff1.field_72449_c * diff2.field_72448_b, diff1.field_72450_a * diff2.field_72449_c - diff1.field_72449_c * diff2.field_72450_a, diff1.field_72450_a * diff2.field_72448_b - diff1.field_72448_b * diff2.field_72450_a).func_72432_b().func_186678_a(-1.0);
        Vec3d normal2 = new Vec3d(normal1.field_72449_c, -normal1.field_72448_b, normal1.field_72450_a).func_186678_a(-1.0);
        Vec3d normal3 = new Vec3d(-normal1.field_72450_a, -normal1.field_72448_b, -normal1.field_72449_c).func_186678_a(-1.0);
        Vec3d normal4 = new Vec3d(-normal1.field_72449_c, -normal1.field_72448_b, -normal1.field_72450_a).func_186678_a(-1.0);
        Vec3d normal5 = new Vec3d(normal1.field_72450_a, normal1.field_72448_b, normal1.field_72449_c).func_186678_a(-1.0);
        Vec3d normal6 = new Vec3d(normal1.field_72449_c, normal1.field_72448_b, normal1.field_72450_a).func_186678_a(-1.0);
        Vec3d normal7 = new Vec3d(-normal1.field_72450_a, normal1.field_72448_b, -normal1.field_72449_c).func_186678_a(-1.0);
        Vec3d normal8 = new Vec3d(-normal1.field_72449_c, normal1.field_72448_b, -normal1.field_72450_a).func_186678_a(-1.0);
        normal1 = new Vec3d(normal1.field_72450_a, -normal1.field_72448_b, normal1.field_72449_c).func_186678_a(-1.0);
        buf.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal1.field_72450_a, (float)normal1.field_72448_b, (float)normal1.field_72449_c).func_181675_d();
        buf.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)minU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal1.field_72450_a, (float)normal1.field_72448_b, (float)normal1.field_72449_c).func_181675_d();
        buf.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)maxU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal1.field_72450_a, (float)normal1.field_72448_b, (float)normal1.field_72449_c).func_181675_d();
        buf.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal2.field_72450_a, (float)normal2.field_72448_b, (float)normal2.field_72449_c).func_181675_d();
        buf.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)minU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal2.field_72450_a, (float)normal2.field_72448_b, (float)normal2.field_72449_c).func_181675_d();
        buf.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)maxU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal2.field_72450_a, (float)normal2.field_72448_b, (float)normal2.field_72449_c).func_181675_d();
        buf.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal3.field_72450_a, (float)normal3.field_72448_b, (float)normal3.field_72449_c).func_181675_d();
        buf.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)minU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal3.field_72450_a, (float)normal3.field_72448_b, (float)normal3.field_72449_c).func_181675_d();
        buf.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)maxU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal3.field_72450_a, (float)normal3.field_72448_b, (float)normal3.field_72449_c).func_181675_d();
        buf.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal4.field_72450_a, (float)normal4.field_72448_b, (float)normal4.field_72449_c).func_181675_d();
        buf.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)minU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal4.field_72450_a, (float)normal4.field_72448_b, (float)normal4.field_72449_c).func_181675_d();
        buf.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)maxU, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal4.field_72450_a, (float)normal4.field_72448_b, (float)normal4.field_72449_c).func_181675_d();
        buf.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal5.field_72450_a, (float)normal5.field_72448_b, (float)normal5.field_72449_c).func_181675_d();
        buf.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)minU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal5.field_72450_a, (float)normal5.field_72448_b, (float)normal5.field_72449_c).func_181675_d();
        buf.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)maxU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal5.field_72450_a, (float)normal5.field_72448_b, (float)normal5.field_72449_c).func_181675_d();
        buf.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal6.field_72450_a, (float)normal6.field_72448_b, (float)normal6.field_72449_c).func_181675_d();
        buf.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)minU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal6.field_72450_a, (float)normal6.field_72448_b, (float)normal6.field_72449_c).func_181675_d();
        buf.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)maxU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal6.field_72450_a, (float)normal6.field_72448_b, (float)normal6.field_72449_c).func_181675_d();
        buf.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal7.field_72450_a, (float)normal7.field_72448_b, (float)normal7.field_72449_c).func_181675_d();
        buf.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)minU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal7.field_72450_a, (float)normal7.field_72448_b, (float)normal7.field_72449_c).func_181675_d();
        buf.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)maxU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal7.field_72450_a, (float)normal7.field_72448_b, (float)normal7.field_72449_c).func_181675_d();
        buf.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181666_a(r, g, b, a).func_181663_c((float)normal8.field_72450_a, (float)normal8.field_72448_b, (float)normal8.field_72449_c).func_181675_d();
        buf.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)minU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal8.field_72450_a, (float)normal8.field_72448_b, (float)normal8.field_72449_c).func_181675_d();
        buf.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)maxU, (double)maxV).func_181666_a(r, g, b, a).func_181663_c((float)normal8.field_72450_a, (float)normal8.field_72448_b, (float)normal8.field_72449_c).func_181675_d();
    }

    public static void drawCrystal(BufferBuilder b, float x, float y, float z, float rotation, float hsize, float ysize, float minU, float minV, float maxU, float maxV) {
        float offX1 = hsize * 0.5f * (float)Math.sin(Math.toRadians(rotation));
        float offZ1 = hsize * 0.5f * (float)Math.cos(Math.toRadians(rotation));
        float offX2 = hsize * 0.5f * (float)Math.sin(Math.toRadians(rotation + 90.0f));
        float offZ2 = hsize * 0.5f * (float)Math.cos(Math.toRadians(rotation + 90.0f));
        float pos1X = x;
        double pos1Y = y - ysize * 0.5f;
        double pos1Z = z;
        double pos2X = x + offX1;
        double pos2Y = y;
        double pos2Z = z + offZ1;
        double pos3X = x + offX2;
        double pos3Y = y;
        double pos3Z = z + offZ2;
        double pos4X = x - offX1;
        double pos4Y = y;
        double pos4Z = z - offZ1;
        double pos5X = x - offX2;
        double pos5Y = y;
        double pos5Z = z - offZ2;
        double pos6X = x;
        double pos6Y = y + ysize * 0.5f;
        double pos6Z = z;
        Vec3d diff1 = new Vec3d(pos3X - (double)pos1X, pos3Y - pos1Y, pos3Z - pos1Z);
        Vec3d diff2 = new Vec3d(pos2X - (double)pos1X, pos2Y - pos1Y, pos2Z - pos1Z);
        Vec3d normal1 = new Vec3d(diff1.field_72448_b * diff2.field_72449_c - diff1.field_72449_c * diff2.field_72448_b, diff1.field_72450_a * diff2.field_72449_c - diff1.field_72449_c * diff2.field_72450_a, diff1.field_72450_a * diff2.field_72448_b - diff1.field_72448_b * diff2.field_72450_a).func_72432_b().func_186678_a(-1.0);
        Vec3d normal2 = new Vec3d(normal1.field_72449_c, -normal1.field_72448_b, normal1.field_72450_a).func_186678_a(-1.0);
        Vec3d normal3 = new Vec3d(-normal1.field_72450_a, -normal1.field_72448_b, -normal1.field_72449_c).func_186678_a(-1.0);
        Vec3d normal4 = new Vec3d(-normal1.field_72449_c, -normal1.field_72448_b, -normal1.field_72450_a).func_186678_a(-1.0);
        Vec3d normal5 = new Vec3d(normal1.field_72450_a, normal1.field_72448_b, normal1.field_72449_c).func_186678_a(-1.0);
        Vec3d normal6 = new Vec3d(normal1.field_72449_c, normal1.field_72448_b, normal1.field_72450_a).func_186678_a(-1.0);
        Vec3d normal7 = new Vec3d(-normal1.field_72450_a, normal1.field_72448_b, -normal1.field_72449_c).func_186678_a(-1.0);
        Vec3d normal8 = new Vec3d(-normal1.field_72449_c, normal1.field_72448_b, -normal1.field_72450_a).func_186678_a(-1.0);
        normal1 = new Vec3d(normal1.field_72450_a, -normal1.field_72448_b, normal1.field_72449_c).func_186678_a(-1.0);
        b.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal1.field_72450_a, (float)normal1.field_72448_b, (float)normal1.field_72449_c).func_181675_d();
        b.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)minU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal1.field_72450_a, (float)normal1.field_72448_b, (float)normal1.field_72449_c).func_181675_d();
        b.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)maxU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal1.field_72450_a, (float)normal1.field_72448_b, (float)normal1.field_72449_c).func_181675_d();
        b.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal2.field_72450_a, (float)normal2.field_72448_b, (float)normal2.field_72449_c).func_181675_d();
        b.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)minU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal2.field_72450_a, (float)normal2.field_72448_b, (float)normal2.field_72449_c).func_181675_d();
        b.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)maxU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal2.field_72450_a, (float)normal2.field_72448_b, (float)normal2.field_72449_c).func_181675_d();
        b.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal3.field_72450_a, (float)normal3.field_72448_b, (float)normal3.field_72449_c).func_181675_d();
        b.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)minU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal3.field_72450_a, (float)normal3.field_72448_b, (float)normal3.field_72449_c).func_181675_d();
        b.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)maxU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal3.field_72450_a, (float)normal3.field_72448_b, (float)normal3.field_72449_c).func_181675_d();
        b.func_181662_b((double)pos1X, pos1Y, pos1Z).func_187315_a((double)(minU + maxU) / 2.0, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal4.field_72450_a, (float)normal4.field_72448_b, (float)normal4.field_72449_c).func_181675_d();
        b.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)minU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal4.field_72450_a, (float)normal4.field_72448_b, (float)normal4.field_72449_c).func_181675_d();
        b.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)maxU, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal4.field_72450_a, (float)normal4.field_72448_b, (float)normal4.field_72449_c).func_181675_d();
        b.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal5.field_72450_a, (float)normal5.field_72448_b, (float)normal5.field_72449_c).func_181675_d();
        b.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)minU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal5.field_72450_a, (float)normal5.field_72448_b, (float)normal5.field_72449_c).func_181675_d();
        b.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)maxU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal5.field_72450_a, (float)normal5.field_72448_b, (float)normal5.field_72449_c).func_181675_d();
        b.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal6.field_72450_a, (float)normal6.field_72448_b, (float)normal6.field_72449_c).func_181675_d();
        b.func_181662_b(pos3X, pos3Y, pos3Z).func_187315_a((double)minU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal6.field_72450_a, (float)normal6.field_72448_b, (float)normal6.field_72449_c).func_181675_d();
        b.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)maxU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal6.field_72450_a, (float)normal6.field_72448_b, (float)normal6.field_72449_c).func_181675_d();
        b.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal7.field_72450_a, (float)normal7.field_72448_b, (float)normal7.field_72449_c).func_181675_d();
        b.func_181662_b(pos4X, pos4Y, pos4Z).func_187315_a((double)minU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal7.field_72450_a, (float)normal7.field_72448_b, (float)normal7.field_72449_c).func_181675_d();
        b.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)maxU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal7.field_72450_a, (float)normal7.field_72448_b, (float)normal7.field_72449_c).func_181675_d();
        b.func_181662_b(pos6X, pos6Y, pos6Z).func_187315_a((double)(minU + maxU) / 2.0, (double)minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal8.field_72450_a, (float)normal8.field_72448_b, (float)normal8.field_72449_c).func_181675_d();
        b.func_181662_b(pos5X, pos5Y, pos5Z).func_187315_a((double)minU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal8.field_72450_a, (float)normal8.field_72448_b, (float)normal8.field_72449_c).func_181675_d();
        b.func_181662_b(pos2X, pos2Y, pos2Z).func_187315_a((double)maxU, (double)maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)normal8.field_72450_a, (float)normal8.field_72448_b, (float)normal8.field_72449_c).func_181675_d();
    }
}

