/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.handler;

import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.util.LogHelper;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import java.io.File;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class ConfigurationHandler {
    private static boolean initialized;
    public static ConfigFile config;
    public static boolean clientCheckUpdates;
    public static boolean disableVanillaEnderChest;
    public static boolean removeVanillaRecipe;
    public static boolean anarchyMode;
    public static ItemStack personalItem;

    public static void init(File file) {
        if (!initialized) {
            config = new ConfigFile(file).setComment("EnderStorage Configuration File\nDeleting any element will restore it to it's default value");
            initialized = true;
        }
        ConfigurationHandler.loadConfig();
    }

    public static void loadConfig() {
        int meta;
        Item item;
        clientCheckUpdates = config.getTag("clientUpdateCheck").getBooleanValue(true);
        disableVanillaEnderChest = config.getTag("disableVanilla").setComment("Set to true to make the vanilla EnderChest un-placeable.").getBooleanValue(true);
        removeVanillaRecipe = config.getTag("disableVanillaRecipe").setComment("Set to true to make the vanilla EnderChest un-craftable").getBooleanValue(false);
        anarchyMode = config.getTag("anarchyMode").setComment("Causes chests to lose personal settings and drop the diamond on break").getBooleanValue(false);
        ConfigTag tag = config.getTag("personalItem").setComment("The name of the item used to set the chest to personal. Diamond by default. Format <modid>:<registeredItemName>|<meta>, Meta can be replaced with \"WILD\"");
        String name = tag.getValue("minecraft:diamond|0");
        try {
            int pipeIndex = name.lastIndexOf("|");
            item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name.substring(0, pipeIndex)));
            if (item == null) {
                throw new Exception("Item does not exist!");
            }
            String metaString = name.substring(pipeIndex + 1);
            meta = metaString.equalsIgnoreCase("WILD") ? Short.MAX_VALUE : Integer.parseInt(metaString);
        }
        catch (Exception e) {
            tag.setValue("minecraft:diamond|0");
            LogHelper.log(Level.ERROR, e, (Object)"Unable to parse Personal item config entry, Resetting to default.");
            item = Items.field_151045_i;
            meta = 0;
        }
        personalItem = new ItemStack(item, 1, meta);
        EnderStorageManager.loadConfig(config);
    }
}

