/*
 * Decompiled with CFR 0.152.
 */
package cofh.api.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ThermalExpansionHelper {
    static final String MOD_ID = "thermalexpansion";
    static final String ENERGY = "energy";
    static final String FLUID = "fluid";
    static final String FLUID_NAME = "fluidName";
    static final String INPUT = "input";
    static final String OUTPUT = "output";
    static final String PRIMARY_INPUT = "primaryInput";
    static final String SECONDARY_INPUT = "secondaryInput";
    static final String PRIMARY_OUTPUT = "primaryOutput";
    static final String SECONDARY_OUTPUT = "secondaryOutput";
    static final String SECONDARY_CHANCE = "secondaryChance";
    public static final String ADD_FURNACE_RECIPE = "addfurnacerecipe";
    public static final String ADD_PULVERIZER_RECIPE = "addpulverizerrecipe";
    public static final String ADD_SAWMILL_RECIPE = "addsawmillrecipe";
    public static final String ADD_SMELTER_RECIPE = "addsmelterrecipe";
    public static final String ADD_INSOLATOR_RECIPE = "addinsolatorrecipe";
    public static final String ADD_COMPACTOR_PRESS_RECIPE = "addcompactorpressrecipe";
    public static final String ADD_COMPACTOR_STORAGE_RECIPE = "addcompactorstoragerecipe";
    public static final String ADD_COMPACTOR_MINT_RECIPE = "addcompactormintrecipe";
    public static final String ADD_CRUCIBLE_RECIPE = "addcruciblerecipe";
    public static final String ADD_REFINERY_RECIPE = "addrefineryrecipe";
    public static final String ADD_TRANSPOSER_FILL_RECIPE = "addtransposerfillrecipe";
    public static final String ADD_TRANSPOSER_EXTRACT_RECIPE = "addtransposerextractrecipe";
    public static final String ADD_CHARGER_RECIPE = "addchargerrecipe";
    public static final String ADD_CENTRIFUGE_RECIPE = "addcentrifugerecipe";
    public static final String REMOVE_FURNACE_RECIPE = "removefurnacerecipe";
    public static final String REMOVE_PULVERIZER_RECIPE = "removepulverizerrecipe";
    public static final String REMOVE_SAWMILL_RECIPE = "removesawmillrecipe";
    public static final String REMOVE_SMELTER_RECIPE = "removesmelterrecipe";
    public static final String REMOVE_INSOLATOR_RECIPE = "removeinsolatorrecipe";
    public static final String REMOVE_COMPACTOR_PRESS_RECIPE = "removecompactorpressrecipe";
    public static final String REMOVE_COMPACTOR_STORAGE_RECIPE = "removecompactorstoragerecipe";
    public static final String REMOVE_COMPACTOR_MINT_RECIPE = "removecompactormintrecipe";
    public static final String REMOVE_CRUCIBLE_RECIPE = "removecruciblerecipe";
    public static final String REMOVE_REFINERY_RECIPE = "removerefineryrecipe";
    public static final String REMOVE_TRANSPOSER_FILL_RECIPE = "removetransposerfillrecipe";
    public static final String REMOVE_TRANSPOSER_EXTRACT_RECIPE = "removetransposerextractrecipe";
    public static final String REMOVE_CHARGER_RECIPE = "removechargerrecipe";
    public static final String REMOVE_CENTRIFUGE_RECIPE = "removecentrifugerecipe";
    public static final String ADD_MAGMATIC_FUEL = "addmagmaticfuel";
    public static final String ADD_COMPRESSION_FUEL = "addcompressionfuel";

    private ThermalExpansionHelper() {
    }

    public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_FURNACE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeFurnaceRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_FURNACE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_PULVERIZER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removePulverizerRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_PULVERIZER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_SAWMILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeSawmillRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_SAWMILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_SMELTER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeSmelterRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_SMELTER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_INSOLATOR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeInsolatorRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_INSOLATOR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorPressRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_PRESS_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorStorageRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_STORAGE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorMintRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_MINT_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorPressRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_PRESS_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorStorageRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_STORAGE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorMintRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_MINT_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        if (input.func_190926_b() || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_CRUCIBLE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCrucibleRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_CRUCIBLE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addRefineryRecipe(int energy, FluidStack input, FluidStack output, ItemStack outputItem) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        if (!outputItem.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            outputItem.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
        }
        input.writeToNBT(toSend.func_74775_l(INPUT));
        output.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_REFINERY_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeRefineryRecipe(FluidStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_REFINERY_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        toSend.func_74757_a("reversible", reversible);
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_TRANSPOSER_FILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        toSend.func_74757_a("reversible", reversible);
        toSend.func_74768_a("chance", chance);
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_TRANSPOSER_EXTRACT_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeTransposerFill(ItemStack input, FluidStack fluid) {
        if (input.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_TRANSPOSER_FILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeTransposerExtract(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_TRANSPOSER_EXTRACT_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addChargerRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_CHARGER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeChargerRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_CHARGER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void setRemoveCentrifugeRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_CENTRIFUGE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addMagmaticFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID_NAME, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_MAGMATIC_FUEL, (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID_NAME, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPRESSION_FUEL, (NBTTagCompound)toSend);
    }
}

