/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.core.util.RegistrySocial;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.translation.I18n;

public class CommandHand
implements ISubCommand {
    public static final CommandHand INSTANCE = new CommandHand();
    private static HashMap<String, InfoType> infoMap = new HashMap();

    @Override
    public String getCommandName() {
        return "hand";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int l = args.length;
        int i = 0;
        EntityPlayerMP player = null;
        ItemStack itemstack = ItemStack.field_190927_a;
        switch (l) {
            case 0: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.command.syntaxError", new Object[0]));
                throw new WrongUsageException("chat.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
            default: {
                try {
                    player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[++i]);
                }
                catch (CommandException t) {
                    if (!infoMap.containsKey(args[i])) {
                        throw t;
                    }
                    --i;
                }
                if (player == null || player == sender || CommandHandler.canUseCommand(sender, 1, this.getCommandName()) || RegistrySocial.playerHasAccess(sender.func_70005_c_(), player.func_146103_bH())) break;
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            case 1: 
        }
        if (player == null) {
            player = CommandBase.func_71521_c((ICommandSender)sender);
        }
        if ((itemstack = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b()) {
            player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (itemstack.func_190926_b()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.enchant.noItem", new Object[0]));
            return;
        }
        ArrayList<InfoType> list = new ArrayList<InfoType>();
        if (++i == l) {
            list.add(InfoType.Name);
        } else {
            while (i < l) {
                InfoType type = infoMap.get(args[i].toLowerCase());
                if (type == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.command.syntaxError", new Object[0]));
                    throw new WrongUsageException("chat.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
                }
                list.add(type);
                ++i;
            }
        }
        for (InfoType type : list) {
            ITextComponent[] data = type.getData(itemstack);
            TextComponentString msg = new TextComponentString(type.name() + ": ");
            if (data.length >= 1 && data[0] != null) {
                msg.func_150257_a(data[0]);
            }
            sender.func_145747_a((ITextComponent)msg);
            for (i = 1; i < data.length; ++i) {
                sender.func_145747_a(data[i]);
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return CommandBase.func_175762_a((String[])args, infoMap.keySet());
    }

    static {
        InfoType.values();
    }

    private static enum InfoType {
        Name(new String[]{"generic"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                TextComponentString component = new TextComponentString("");
                component.func_150257_a(stack.func_151000_E());
                if (stack.func_82837_s()) {
                    String s = stack.func_77973_b().func_77667_c(stack);
                    if (!I18n.func_94522_b((String)s)) {
                        s = s + ".name";
                    }
                    TextComponentTranslation component2 = new TextComponentTranslation(s, new Object[0]);
                    component2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(s)));
                    component.func_150258_a(" (").func_150257_a((ITextComponent)component2).func_150258_a(")");
                }
                return component;
            }
        }
        ,
        Id{

            @Override
            public ITextComponent processStack(ItemStack stack) {
                return new TextComponentString(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString());
            }
        }
        ,
        Size(new String[]{"amount", "count"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                return new TextComponentString(String.valueOf(stack.func_190916_E()));
            }
        }
        ,
        Metadata(new String[]{"damage", "alt"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                return new TextComponentString(String.valueOf(ItemHelper.getItemDamage(stack)));
            }
        }
        ,
        toString(new String[]{"string", "text"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                return new TextComponentString(stack.toString());
            }
        }
        ,
        Action(new String[]{"use"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                EnumAction action = stack.func_77975_n();
                TextComponentString component = new TextComponentString(action.name());
                if (action != EnumAction.NONE) {
                    component.func_150258_a(" | Duration: " + stack.func_77988_m());
                }
                return component;
            }
        }
        ,
        Lore(new String[]{"flavorText"}){

            @Override
            public ITextComponent[] getData(ItemStack stack) {
                LinkedList<TextComponentString> ret = new LinkedList<TextComponentString>();
                ret.add(null);
                if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10)) {
                    NBTTagList nbttaglist1;
                    NBTTagCompound nbttagcompound = stack.func_77978_p().func_74775_l("display");
                    if (nbttagcompound.func_150299_b("Lore") == 9 && (nbttaglist1 = nbttagcompound.func_150295_c("Lore", 8)).func_74745_c() > 0) {
                        for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                            ret.add(new TextComponentString("\u00a75      \u00a7o" + nbttaglist1.func_150307_f(j)));
                        }
                    }
                } else {
                    ret.set(0, new TextComponentString("none"));
                }
                return ret.toArray(new ITextComponent[ret.size()]);
            }
        }
        ,
        Enchants(new String[]{"enchant", "ench"}){

            @Override
            public ITextComponent[] getData(ItemStack stack) {
                NBTTagList nbttaglist = stack.func_77986_q();
                LinkedList<TextComponentString> ret = new LinkedList<TextComponentString>();
                ret.add(null);
                if (nbttaglist != null && nbttaglist.func_74745_c() > 0) {
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                        short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                        if (Enchantment.func_185262_c((int)short1) != null) {
                            ret.add(new TextComponentString("\u00a73     " + I18n.func_74838_a((String)Enchantment.func_185262_c((int)short1).func_77320_a()) + " " + StringHelper.toNumerals(short2)));
                            continue;
                        }
                        ret.add(new TextComponentString("\u00a74     " + String.format("Invalid{id=%s,lvl=%s}", short1, short2)));
                    }
                } else {
                    ret.set(0, new TextComponentString("none"));
                }
                return ret.toArray(new ITextComponent[ret.size()]);
            }
        }
        ,
        NBT(new String[]{"tag", "stackTag", "compoundTag"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                return new TextComponentString(stack.func_77978_p() != null ? stack.func_77978_p().toString() : null);
            }
        }
        ,
        OreDict(new String[]{"oreNames", "oreName", "ores", "ore"}){

            @Override
            public ITextComponent processStack(ItemStack stack) {
                ArrayList<String> ores = OreDictionaryArbiter.getAllOreNames(stack);
                int size = ores == null ? 0 : ores.size();
                String arr = StringHelper.toString(ores, "[null]");
                return new TextComponentString(size + "> " + arr.substring(1, arr.length() - 1));
            }
        }
        ,
        Modifiers{
            protected final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

            @Override
            public ITextComponent[] getData(ItemStack stack) {
                LinkedList<TextComponentString> ret = new LinkedList<TextComponentString>();
                ret.add(null);
                Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.HEAD);
                if (!multimap.isEmpty()) {
                    for (Map.Entry entry : multimap.entries()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double d0 = attributemodifier.func_111164_d();
                        if (this.field_111210_e.equals(attributemodifier.func_111167_a())) {
                            d0 += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                        }
                        double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                        if (d0 > 0.0) {
                            ret.add(new TextComponentString("     \u00a79" + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))})));
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        d1 = -d1;
                        ret.add(new TextComponentString("     \u00a7c" + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))})));
                    }
                } else {
                    ret.set(0, new TextComponentString("none"));
                }
                return ret.toArray(new ITextComponent[ret.size()]);
            }
        };


        private InfoType() {
            infoMap.put(this.name().toLowerCase(), this);
        }

        private InfoType(String ... alts) {
            this();
            for (String alt : alts) {
                infoMap.put(alt.toLowerCase(), this);
            }
        }

        public ITextComponent processStack(ItemStack stack) {
            return null;
        }

        public ITextComponent[] getData(ItemStack stack) {
            return new ITextComponent[]{this.processStack(stack)};
        }
    }
}

