/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui;

import cofh.core.audio.SoundBase;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabTracker;
import cofh.core.gui.slot.SlotFalseCopy;
import cofh.core.init.CoreTextures;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;

public abstract class GuiContainerCore
extends GuiContainer {
    public static final SoundHandler guiSoundManager = FMLClientHandler.instance().getClient().func_147118_V();
    public static final float CLICK_VOLUME = 0.3f;
    public static final int NONE = 0;
    public static final int INPUT_ALL = 1;
    public static final int OUTPUT_PRIMARY = 2;
    public static final int OUTPUT_SECONDARY = 3;
    public static final int OUTPUT_ALL = 4;
    public static final int INPUT_PRIMARY = 5;
    public static final int INPUT_SECONDARY = 6;
    public static final int OPEN = 7;
    public static final int OMNI = 8;
    public static final String TEX_INFO_INPUT = "cofh:textures/gui/elements/info_input.png";
    public static final String TEX_INFO_OUTPUT = "cofh:textures/gui/elements/info_output.png";
    public static final String TEX_ARROW_LEFT = "cofh:textures/gui/elements/progress_arrow_left.png";
    public static final String TEX_ARROW_RIGHT = "cofh:textures/gui/elements/progress_arrow_right.png";
    public static final String TEX_ARROW_FLUID_LEFT = "cofh:textures/gui/elements/progress_arrow_fluid_left.png";
    public static final String TEX_ARROW_FLUID_RIGHT = "cofh:textures/gui/elements/progress_arrow_fluid_right.png";
    public static final String TEX_DROP_LEFT = "cofh:textures/gui/elements/progress_fluid_left.png";
    public static final String TEX_DROP_RIGHT = "cofh:textures/gui/elements/progress_fluid_right.png";
    public static final String TEX_ALCHEMY = "cofh:textures/gui/elements/scale_alchemy.png";
    public static final String TEX_BUBBLE = "cofh:textures/gui/elements/scale_bubble.png";
    public static final String TEX_COMPACT = "cofh:textures/gui/elements/scale_compact.png";
    public static final String TEX_CRUSH = "cofh:textures/gui/elements/scale_crush.png";
    public static final String TEX_FLAME = "cofh:textures/gui/elements/scale_flame.png";
    public static final String TEX_FLAME_GREEN = "cofh:textures/gui/elements/scale_flame_green.png";
    public static final String TEX_FLUX = "cofh:textures/gui/elements/scale_flux.png";
    public static final String TEX_SAW = "cofh:textures/gui/elements/scale_saw.png";
    public static final String TEX_SPIN = "cofh:textures/gui/elements/scale_spin.png";
    public static final String TEX_SUN = "cofh:textures/gui/elements/scale_sun.png";
    public static final String TEX_SNOWFLAKE = "cofh:textures/gui/elements/scale_snowflake.png";
    public static final String TEX_BUTTONS = "cofh:textures/gui/elements/buttons.png";
    public static final int PROGRESS = 24;
    public static final int SPEED = 16;
    protected String myInfo = "";
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int lastIndex = -1;
    protected String name;
    protected ResourceLocation texture;
    public ArrayList<TabBase> tabs = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<String> tooltip = new LinkedList<String>();
    protected boolean tooltips = true;

    public static void playSound(String name, SoundCategory category, float volume, float pitch) {
        guiSoundManager.func_147682_a((ISound)new SoundBase(name, category, volume, pitch));
    }

    public static void playClickSound(float pitch) {
        guiSoundManager.func_147682_a((ISound)new SoundBase(SoundEvents.field_187909_gi, SoundCategory.MASTER, 0.3f, pitch));
    }

    public GuiContainerCore(Container container) {
        super(container);
    }

    public GuiContainerCore(Container container, ResourceLocation texture) {
        super(container);
        this.texture = texture;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.elements.clear();
    }

    public void func_73863_a(int x, int y, float partialTick) {
        this.updateElementInformation();
        this.func_146276_q_();
        super.func_73863_a(x, y, partialTick);
        this.func_191948_b(x, y);
        if (this.tooltips && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        this.updateElements();
    }

    protected void func_146979_b(int x, int y) {
        if (this.drawTitle & this.name != null) {
            this.field_146289_q.func_78276_b(StringHelper.localize(this.name), this.getCenteredOffset(StringHelper.localize(this.name)), 6, 0x404040);
        }
        if (this.drawInventory) {
            this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 3, 0x404040);
        }
        this.drawElements(0.0f, true);
        this.drawTabs(0.0f, true);
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTick, false);
        this.drawTabs(partialTick, false);
        GlStateManager.func_179121_F();
    }

    protected void func_73869_a(char characterTyped, int keyPressed) throws IOException {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.onKeyTyped(characterTyped, keyPressed)) continue;
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }

    public void func_146274_d() throws IOException {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        int wheelMovement = Mouse.getEventDWheel();
        if (wheelMovement != 0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(this.mouseX, this.mouseY) || !c.onMouseWheel(this.mouseX, this.mouseY, wheelMovement)) continue;
                return;
            }
            TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
            if (tab != null && tab.onMouseWheel(this.mouseX, this.mouseY, wheelMovement)) {
                return;
            }
            if (this.onMouseWheel(this.mouseX, this.mouseY, wheelMovement)) {
                return;
            }
        }
        super.func_146274_d();
    }

    protected boolean onMouseWheel(int mouseX, int mouseY, int wheelMovement) {
        return false;
    }

    protected void generateInfo(String tileString) {
        int i = 0;
        String line = tileString + "." + i;
        while (StringHelper.canLocalize(line)) {
            if (i > 0) {
                this.myInfo = this.myInfo + "\n\n";
            }
            this.myInfo = this.myInfo + StringHelper.localize(line);
            line = tileString + "." + ++i;
        }
    }

    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        int tMx;
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mX, mY) || !c.onMousePressed(mX, mY, mouseButton)) continue;
            return;
        }
        TabBase tab = this.getTabAtPosition(mX, mY);
        if (tab != null && !tab.onMousePressed(tMx = mX, mY, mouseButton)) {
            int i2 = this.tabs.size();
            while (i2-- > 0) {
                TabBase other = this.tabs.get(i2);
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
            return;
        }
        mX += this.field_147003_i;
        mY += this.field_147009_r;
        if (tab != null) {
            switch (tab.side) {
                case 0: {
                    break;
                }
                case 1: {
                    this.field_146999_f += tab.currentWidth;
                }
            }
        }
        super.func_73864_a(mX, mY, mouseButton);
        if (tab != null) {
            switch (tab.side) {
                case 0: {
                    break;
                }
                case 1: {
                    this.field_146999_f -= tab.currentWidth;
                }
            }
        }
    }

    protected void func_146286_b(int mX, int mY, int mouseButton) {
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        if (mouseButton >= 0 && mouseButton <= 2) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled()) continue;
                c.onMouseReleased(mX, mY);
            }
        }
        super.func_146286_b(mX += this.field_147003_i, mY += this.field_147009_r, mouseButton);
    }

    protected void func_146273_a(int mX, int mY, int lastClick, long timeSinceClick) {
        Slot slot = this.func_146975_c(mX, mY);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147007_t && slot != null && !itemstack.func_190926_b() && slot instanceof SlotFalseCopy) {
            if (this.lastIndex != slot.field_75222_d) {
                this.lastIndex = slot.field_75222_d;
                this.func_184098_a(slot, slot.field_75222_d, 0, ClickType.PICKUP);
            }
        } else {
            this.lastIndex = -1;
            super.func_146273_a(mX, mY, lastClick, timeSinceClick);
        }
    }

    public Slot func_146975_c(int xCoord, int yCoord) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.func_146981_a(slot, xCoord, yCoord)) continue;
            return slot;
        }
        return null;
    }

    public boolean func_146981_a(Slot theSlot, int xCoord, int yCoord) {
        return this.func_146978_c(theSlot.field_75223_e, theSlot.field_75221_f, 16, 16, xCoord, yCoord);
    }

    protected void drawElements(float partialTick, boolean foreground) {
        if (foreground) {
            for (ElementBase element : this.elements) {
                if (!element.isVisible()) continue;
                element.drawForeground(this.mouseX, this.mouseY);
            }
        } else {
            for (ElementBase element : this.elements) {
                if (!element.isVisible()) continue;
                element.drawBackground(this.mouseX, this.mouseY, partialTick);
            }
        }
    }

    protected void drawTabs(float partialTick, boolean foreground) {
        int yPosRight = 4;
        int yPosLeft = 4;
        if (foreground) {
            for (TabBase tab : this.tabs) {
                tab.update();
                if (!tab.isVisible()) continue;
                if (tab.side == 0) {
                    tab.drawForeground(this.mouseX, this.mouseY);
                    yPosLeft += tab.currentHeight;
                    continue;
                }
                tab.drawForeground(this.mouseX, this.mouseY);
                yPosRight += tab.currentHeight;
            }
        } else {
            for (TabBase tab : this.tabs) {
                tab.update();
                if (!tab.isVisible()) continue;
                if (tab.side == 0) {
                    tab.setPosition(0, yPosLeft);
                    tab.drawBackground(this.mouseX, this.mouseY, partialTick);
                    yPosLeft += tab.currentHeight;
                    continue;
                }
                tab.setPosition(this.field_146999_f, yPosRight);
                tab.drawBackground(this.mouseX, this.mouseY, partialTick);
                yPosRight += tab.currentHeight;
            }
        }
    }

    public void addTooltips(List<String> tooltip) {
        ElementBase element;
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null) {
            tab.addTooltip(tooltip);
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null && element.isVisible()) {
            element.addTooltip(tooltip);
        }
    }

    public ElementBase addElement(ElementBase element) {
        this.elements.add(element);
        return element;
    }

    public TabBase addTab(TabBase tab) {
        int yOffset = 4;
        for (TabBase tab1 : this.tabs) {
            if (tab1.side != tab.side || !tab1.isVisible()) continue;
            yOffset += tab1.currentHeight;
        }
        tab.setPosition(tab.side == 0 ? 0 : this.field_146999_f, yOffset);
        this.tabs.add(tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    public TabBase addTab(TabBase tab, int index) {
        int yOffset = 4;
        for (TabBase tab1 : this.tabs) {
            if (tab1.side != tab.side || !tab1.isVisible()) continue;
            yOffset += tab1.currentHeight;
        }
        tab.setPosition(tab.side == 0 ? 0 : this.field_146999_f, yOffset);
        this.tabs.add(index, tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.setCurrentShift(xShift, yShift);
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.setCurrentShift(xShift, yShift);
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    protected final void updateElements() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.update(this.mouseX, this.mouseY);
        }
    }

    protected void updateElementInformation() {
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
    }

    public void bindTexture(ResourceLocation texture) {
        this.field_146297_k.field_71446_o.func_110577_a(texture);
    }

    public void drawButton(TextureAtlasSprite icon, int x, int y, int mode) {
        switch (mode) {
            case 0: {
                this.drawIcon(CoreTextures.ICON_BUTTON, x, y);
                break;
            }
            case 1: {
                this.drawIcon(CoreTextures.ICON_BUTTON_HIGHLIGHT, x, y);
                break;
            }
            default: {
                this.drawIcon(CoreTextures.ICON_BUTTON_INACTIVE, x, y);
            }
        }
        this.drawIcon(icon, x, y);
    }

    public void drawItemStack(ItemStack stack, int x, int y, boolean drawOverlay, String overlayTxt) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        if (drawOverlay) {
            this.field_146296_j.func_180453_a(font, stack, x, y - (this.field_147012_x.func_190926_b() ? 0 : 8), overlayTxt);
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
    }

    public void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null) {
            return;
        }
        RenderHelper.setBlockTextureSheet();
        int color = fluid.getFluid().getColor(fluid);
        RenderHelper.setGLColorFromInt(color);
        this.drawTiledTexture(x, y, RenderHelper.getTexture(fluid.getFluid().getStill(fluid)), width, height);
    }

    public void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(TextureAtlasSprite icon, int x, int y) {
        RenderHelper.setBlockTextureSheet();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_175175_a(x, y, icon, 16, 16);
    }

    public void drawColorIcon(TextureAtlasSprite icon, int x, int y) {
        this.func_175175_a(x, y, icon, 16, 16);
    }

    public void drawSizedModalRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)x1, (double)y2, (double)this.field_73735_i).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)this.field_73735_i).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, (double)this.field_73735_i).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, (double)this.field_73735_i).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawSizedRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)x1, (double)y2, (double)this.field_73735_i).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)this.field_73735_i).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, (double)this.field_73735_i).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, (double)this.field_73735_i).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)u * texU), (double)((float)(v + height) * texV)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(u + width) * texU), (double)((float)(v + height) * texV)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((float)(u + width) * texU), (double)((float)v * texV)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)((float)u * texU), (double)((float)v * texV)).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(minU, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void drawTooltip(List<String> list) {
        this.drawTooltipHoveringText(list, this.mouseX + this.field_147003_i, this.mouseY + this.field_147009_r, this.field_146289_q);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List<String> list, int x, int y, FontRenderer font) {
        if (list == null || list.isEmpty()) {
            return;
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        int k = 0;
        for (String s : list) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = x + 12;
        int j1 = y - 12;
        int k1 = 8;
        if (list.size() > 1) {
            k1 += 2 + (list.size() - 1) * 10;
        }
        if (i1 + k > this.field_146294_l) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_146295_m) {
            j1 = this.field_146295_m - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        this.field_146296_j.field_77023_b = 300.0f;
        int l1 = -267386864;
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            String s1 = list.get(k2);
            font.func_175063_a(s1, (float)i1, (float)j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
    }

    public void mouseClicked(int mouseButton) throws IOException {
        super.func_73864_a(this.field_147003_i + this.mouseX, this.field_147009_r + this.mouseY, mouseButton);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_146289_q.func_78256_a(string)) / 2;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }
}

