/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.container;

import cofh.core.gui.slot.SlotFalseCopy;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.MathHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerCore
extends Container {
    protected abstract int getPlayerInventoryVerticalOffset();

    protected int getPlayerInventoryHorizontalOffset() {
        return 8;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int yOff = this.getPlayerInventoryVerticalOffset();
        int xOff = this.getPlayerInventoryHorizontalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOff + j * 18, yOff + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOff + i * 18, yOff + 58));
        }
    }

    protected abstract int getSizeInventory();

    protected boolean supportsShiftClick(EntityPlayer player, int slotIndex) {
        return this.supportsShiftClick(slotIndex);
    }

    protected boolean supportsShiftClick(int slotIndex) {
        return true;
    }

    protected boolean performMerge(EntityPlayer player, int slotIndex, ItemStack stack) {
        return this.performMerge(slotIndex, stack);
    }

    protected boolean performMerge(int slotIndex, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.field_75151_b.size();
        if (slotIndex < invBase) {
            return this.func_75135_a(stack, invBase, invFull, true);
        }
        return this.func_75135_a(stack, 0, invBase, false);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, stack);
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(stackInSlot);
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return stack;
    }

    protected void sendSlots(int start, int end) {
        end = MathHelper.clamp(end, 0, this.field_75151_b.size());
        for (start = MathHelper.clamp(start, 0, this.field_75151_b.size()); start < end; ++start) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(start)).func_75211_c();
            ItemStack itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
            this.field_75153_a.set(start, (Object)itemstack1);
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((IContainerListener)this.field_75149_d.get(j)).func_71111_a((Container)this, start, itemstack1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.func_75141_a(i, stacks.get(i));
        }
    }

    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof SlotFalseCopy) {
            if (mouseButton == 2) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_190926_b() ? ItemStack.field_190927_a : player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        return super.func_184996_a(slotId, mouseButton, modifier, player);
    }

    protected boolean func_75135_a(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        return InventoryHelper.mergeItemStack(this.field_75151_b, stack, slotMin, slotMax, ascending);
    }
}

