/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyStorage;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ElementEnergyStored
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/energy.png");
    public static final int DEFAULT_SCALE = 42;
    protected IEnergyStorage storage;
    protected boolean alwaysShowMinimum = false;

    public ElementEnergyStored(GuiContainerCore gui, int posX, int posY, IEnergyStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.texture = DEFAULT_TEXTURE;
        this.sizeX = 16;
        this.sizeY = 42;
        this.texW = 32;
        this.texH = 64;
    }

    public ElementEnergyStored setAlwaysShow(boolean show) {
        this.alwaysShowMinimum = show;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int amount = this.getScaled();
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        this.drawTexturedModalRect(this.posX, this.posY + 42 - amount, 16, 42 - amount, this.sizeX, amount);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.storage.getMaxEnergyStored() < 0) {
            list.add("Infinite RF");
        } else {
            list.add(StringHelper.formatNumber(this.storage.getEnergyStored()) + " / " + StringHelper.formatNumber(this.storage.getMaxEnergyStored()) + " RF");
        }
    }

    protected int getScaled() {
        if (this.storage.getMaxEnergyStored() <= 0) {
            return this.sizeY;
        }
        long fraction = (long)this.storage.getEnergyStored() * (long)this.sizeY / (long)this.storage.getMaxEnergyStored();
        return this.alwaysShowMinimum && this.storage.getEnergyStored() > 0 ? Math.max(1, MathHelper.round(fraction)) : MathHelper.round(fraction);
    }
}

