/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class ElementFluidTank
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/fluid_tank.png");
    public static final ResourceLocation SHORT_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/fluid_tank_short.png");
    public static final ResourceLocation THIN_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/fluid_tank_thin.png");
    protected IFluidTank tank;
    protected int gaugeType;
    protected boolean drawTank;
    protected boolean alwaysShowMinimum = false;
    protected TextureAtlasSprite fluidTextureOverride;

    public ElementFluidTank(GuiContainerCore gui, int posX, int posY, IFluidTank tank) {
        this(gui, posX, posY, tank, DEFAULT_TEXTURE);
    }

    public ElementFluidTank(GuiContainerCore gui, int posX, int posY, IFluidTank tank, ResourceLocation texture) {
        super(gui, posX, posY);
        this.tank = tank;
        this.texture = texture;
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 16;
        this.sizeY = 60;
    }

    public ElementFluidTank setGauge(int gaugeType) {
        this.gaugeType = gaugeType;
        return this;
    }

    public ElementFluidTank setDefault() {
        this.texture = DEFAULT_TEXTURE;
        this.sizeX = 16;
        this.sizeY = 60;
        return this;
    }

    public ElementFluidTank setThin() {
        this.texture = THIN_TEXTURE;
        this.sizeX = 7;
        return this;
    }

    public ElementFluidTank setShort() {
        this.texture = SHORT_TEXTURE;
        this.sizeY = 30;
        return this;
    }

    public ElementFluidTank setFluidTextureOverride(TextureAtlasSprite fluidTextureOverride) {
        this.fluidTextureOverride = fluidTextureOverride;
        return this;
    }

    public ElementFluidTank drawTank(boolean drawTank) {
        this.drawTank = drawTank;
        return this;
    }

    public ElementFluidTank setAlwaysShow(boolean show) {
        this.alwaysShowMinimum = show;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.drawTank) {
            RenderHelper.bindTexture(this.texture);
            this.drawTexturedModalRect(this.posX - 1, this.posY - 1, 0, 0, this.sizeX + 2, this.sizeY + 2);
        }
        this.drawFluid();
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 32 + this.gaugeType * 16, 1, this.sizeX, this.sizeY);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            list.add(StringHelper.getFluidName(this.tank.getFluid()));
        }
        if (this.tank.getCapacity() < 0) {
            list.add("Infinite Fluid");
        } else {
            list.add(StringHelper.formatNumber(this.tank.getFluidAmount()) + " / " + StringHelper.formatNumber(this.tank.getCapacity()) + " mB");
        }
    }

    protected int getScaled() {
        if (this.tank.getCapacity() < 0) {
            return this.sizeY;
        }
        long fraction = (long)this.tank.getFluidAmount() * (long)this.sizeY / (long)this.tank.getCapacity();
        return this.alwaysShowMinimum && this.tank.getFluidAmount() > 0 ? Math.max(1, MathHelper.ceil(fraction)) : MathHelper.ceil(fraction);
    }

    protected void drawFluid() {
        int amount = this.getScaled();
        if (this.fluidTextureOverride != null) {
            RenderHelper.setBlockTextureSheet();
            this.gui.drawTiledTexture(this.posX, this.posY + this.sizeY - amount, this.fluidTextureOverride, this.sizeX, amount);
        } else {
            this.gui.drawFluid(this.posX, this.posY + this.sizeY - amount, this.tank.getFluid(), this.sizeX, amount);
        }
    }
}

