/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.api.item.INBTCopyIngredient;
import cofh.api.item.IUpgradeItem;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessUpgradeKitRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapelessOreRecipe recipe = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
        return new ShapelessUpgradeKitRecipe(new ResourceLocation("cofh", "upgrade_kit_shapeless"), recipe.func_77571_b(), recipe.func_192400_c().toArray());
    }

    public static class ShapelessUpgradeKitRecipe
    extends ShapelessOreRecipe {
        public ShapelessUpgradeKitRecipe(ResourceLocation group, ItemStack result, Object ... recipe) {
            super(group, result, recipe);
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            ItemStack inputStack = ItemStack.field_190927_a;
            ItemStack outputStack = this.output.func_77946_l();
            ItemStack upgradeStack = ItemStack.field_190927_a;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof INBTCopyIngredient) {
                    inputStack = stack;
                    continue;
                }
                if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof INBTCopyIngredient) {
                    inputStack = stack;
                    continue;
                }
                if (!AugmentHelper.isUpgradeItem(stack)) continue;
                upgradeStack = stack;
            }
            if (inputStack.func_190926_b() || upgradeStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int curLevel = AugmentHelper.getLevel(inputStack);
            byte upgradeLevel = AugmentHelper.getUpgradeLevel(upgradeStack);
            IUpgradeItem.UpgradeType upgradeType = AugmentHelper.getUpgradeType(upgradeStack);
            if (upgradeLevel <= curLevel || upgradeType == IUpgradeItem.UpgradeType.INCREMENTAL && curLevel + 1 != upgradeLevel) {
                return ItemStack.field_190927_a;
            }
            outputStack = ItemHelper.copyTag(outputStack, inputStack);
            if (upgradeType == IUpgradeItem.UpgradeType.CREATIVE) {
                return AugmentHelper.setCreative(outputStack);
            }
            return AugmentHelper.setLevel(outputStack, upgradeLevel);
        }
    }
}

