/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockHelper {
    public static int MAX_ID = 1024;
    public static byte[] rotateType = new byte[MAX_ID];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static float[][] SIDE_COORD_AABB = new float[][]{{1.0f, -2.0f, 1.0f}, {1.0f, 2.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 2.0f}, {1.0f, 1.0f, 1.0f}, {2.0f, 1.0f, 1.0f}};
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};
    public static final byte[] ROTATE_CLOCK_Y = new byte[]{0, 1, 4, 5, 3, 2};
    public static final byte[] ROTATE_CLOCK_Z = new byte[]{5, 4, 2, 3, 0, 1};
    public static final byte[] ROTATE_CLOCK_X = new byte[]{2, 3, 1, 0, 4, 5};
    public static final byte[] ROTATE_COUNTER_Y = new byte[]{0, 1, 5, 4, 2, 3};
    public static final byte[] ROTATE_COUNTER_Z = new byte[]{4, 5, 2, 3, 1, 0};
    public static final byte[] ROTATE_COUNTER_X = new byte[]{3, 2, 0, 1, 4, 5};
    public static final byte[] INVERT_AROUND_Y = new byte[]{0, 1, 3, 2, 5, 4};
    public static final byte[] INVERT_AROUND_Z = new byte[]{1, 0, 2, 3, 5, 4};
    public static final byte[] INVERT_AROUND_X = new byte[]{1, 0, 3, 2, 4, 5};
    public static final byte[][] ICON_ROTATION_MAP = new byte[6][];

    private BlockHelper() {
    }

    public static int getHighestY(World world, int x, int z) {
        return world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16;
    }

    public static int getSurfaceBlockY(World world, int x, int z) {
        BlockPos pos;
        IBlockState state;
        Block block;
        int y = world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16;
        while (--y >= 0 && ((block = (state = world.func_180495_p(pos = new BlockPos(x, y, z))).func_177230_c()).isAir(state, (IBlockAccess)world, pos) || block.func_176200_f((IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos) || block.isFoliage((IBlockAccess)world, pos) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, pos))) {
        }
        return y;
    }

    public static int getTopBlockY(World world, int x, int z) {
        BlockPos pos;
        IBlockState state;
        Block block;
        int y = world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16;
        while (--y >= 0 && (block = (state = world.func_180495_p(pos = new BlockPos(x, y, z))).func_177230_c()).isAir(state, (IBlockAccess)world, pos)) {
        }
        return y;
    }

    public static int determineXZPlaceFacing(EntityLivingBase living) {
        int quadrant = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 3;
    }

    public static boolean isEqual(Block blockA, Block blockB) {
        if (blockA == blockB) {
            return true;
        }
        if (blockA == null | blockB == null) {
            return false;
        }
        return blockA.equals(blockB) || blockA.func_149667_c(blockB);
    }

    public static IBlockState getAdjacentBlock(World world, BlockPos pos, EnumFacing dir) {
        pos = pos.func_177972_a(dir);
        return world == null || !world.func_175667_e(pos) ? Blocks.field_150350_a.func_176223_P() : world.func_180495_p(pos);
    }

    public static TileEntity getAdjacentTileEntity(World world, BlockPos pos, EnumFacing dir) {
        pos = pos.func_177972_a(dir);
        return world == null || !world.func_175667_e(pos) ? null : world.func_175625_s(pos);
    }

    public static TileEntity getAdjacentTileEntity(World world, BlockPos pos, int side) {
        return world == null ? null : BlockHelper.getAdjacentTileEntity(world, pos, EnumFacing.field_82609_l[side]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, EnumFacing dir) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.func_174877_v(), dir);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, int side) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.func_174877_v(), EnumFacing.field_82609_l[side]);
    }

    public static int determineAdjacentSide(TileEntity refTile, BlockPos pos) {
        return pos.func_177956_o() > refTile.func_174877_v().func_177956_o() ? 1 : (pos.func_177956_o() < refTile.func_174877_v().func_177956_o() ? 0 : (pos.func_177952_p() > refTile.func_174877_v().func_177952_p() ? 3 : (pos.func_177952_p() < refTile.func_174877_v().func_177952_p() ? 2 : (pos.func_177958_n() > refTile.func_174877_v().func_177958_n() ? 5 : 4))));
    }

    public static int[] getAdjacentCoordinatesForSide(RayTraceResult trace) {
        BlockPos pos = trace.func_178782_a();
        return BlockHelper.getAdjacentCoordinatesForSide(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), trace.field_178784_b.ordinal());
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }

    public static AxisAlignedBB getAdjacentAABBForSide(RayTraceResult trace) {
        BlockPos pos = trace.func_178782_a();
        return BlockHelper.getAdjacentAABBForSide(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), trace.field_178784_b.ordinal());
    }

    public static AxisAlignedBB getAdjacentAABBForSide(BlockPos pos, EnumFacing side) {
        return BlockHelper.getAdjacentAABBForSide(pos, side.ordinal());
    }

    public static AxisAlignedBB getAdjacentAABBForSide(BlockPos pos, int side) {
        return BlockHelper.getAdjacentAABBForSide(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side);
    }

    public static AxisAlignedBB getAdjacentAABBForSide(int x, int y, int z, int side) {
        return new AxisAlignedBB((double)(x + SIDE_COORD_MOD[side][0]), (double)(y + SIDE_COORD_MOD[side][1]), (double)(z + SIDE_COORD_MOD[side][2]), (double)((float)x + SIDE_COORD_AABB[side][0]), (double)((float)y + SIDE_COORD_AABB[side][1]), (double)((float)z + SIDE_COORD_AABB[side][2]));
    }

    public static int getLeftSide(int side) {
        return SIDE_LEFT[side];
    }

    public static int getRightSide(int side) {
        return SIDE_RIGHT[side];
    }

    public static int getOppositeSide(int side) {
        return SIDE_OPPOSITE[side];
    }

    public static int getAboveSide(int side) {
        return SIDE_ABOVE[side];
    }

    public static int getBelowSide(int side) {
        return SIDE_BELOW[side];
    }

    public static boolean canRotate(Block block) {
        return Block.func_149682_b((Block)block) < MAX_ID && rotateType[Block.func_149682_b((Block)block)] != 0;
    }

    public static IBlockState rotateVanillaBlock(World world, IBlockState state, BlockPos pos) {
        int bId = Block.func_149682_b((Block)state.func_177230_c());
        int bMeta = state.func_177230_c().func_176201_c(state);
        Block block = state.func_177230_c();
        switch (rotateType[bId]) {
            case 1: {
                return block.func_176203_a(++bMeta % 8);
            }
            case 2: {
                return block.func_176203_a((bMeta + 8) % 16);
            }
            case 3: {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos offsetPos = pos.func_177972_a(facing);
                    if (!BlockHelper.isEqual(world.func_180495_p(offsetPos).func_177230_c(), state.func_177230_c())) continue;
                    world.func_180501_a(offsetPos, state.func_177230_c().func_176203_a((int)SIDE_OPPOSITE[bMeta]), 1);
                    return block.func_176203_a((int)SIDE_OPPOSITE[bMeta]);
                }
                return block.func_176203_a((int)SIDE_LEFT[bMeta]);
            }
        }
        return block.func_176203_a(bMeta);
    }

    public static List<ItemStack> breakBlock(World worldObj, BlockPos pos, IBlockState state, int fortune, boolean doBreak, boolean silkTouch) {
        return BlockHelper.breakBlock(worldObj, null, pos, state, fortune, doBreak, silkTouch);
    }

    public static List<ItemStack> breakBlock(World worldObj, EntityPlayer player, BlockPos pos, IBlockState state, int fortune, boolean doBreak, boolean silkTouch) {
        LinkedList<ItemStack> stacks;
        if (state.func_185887_b(worldObj, pos) == -1.0f) {
            return new LinkedList<ItemStack>();
        }
        if (silkTouch && state.func_177230_c().canSilkHarvest(worldObj, pos, state, player)) {
            stacks = new LinkedList<ItemStack>();
            stacks.add(BlockHelper.createStackedBlock(state));
        } else {
            stacks = state.func_177230_c().getDrops((IBlockAccess)worldObj, pos, state, fortune);
        }
        if (!doBreak) {
            return stacks;
        }
        worldObj.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        worldObj.func_175698_g(pos);
        List result = worldObj.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() + 3), (double)(pos.func_177952_p() + 3)));
        for (EntityItem entity : result) {
            if (entity.field_70128_L || entity.func_92059_d().func_190916_E() <= 0) continue;
            stacks.add(entity.func_92059_d());
            entity.field_70170_p.func_72900_e((Entity)entity);
        }
        return stacks;
    }

    public static ItemStack createStackedBlock(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item.func_77614_k()) {
            return new ItemStack(item, 1, state.func_177230_c().func_176201_c(state));
        }
        return new ItemStack(item, 1, 0);
    }

    public static void callBlockUpdate(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }

    public void callNeighborStateChange(World world, BlockPos pos) {
        world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c(), false);
    }

    public void callNeighborTileChange(World world, BlockPos pos) {
        world.func_175666_e(pos, world.func_180495_p(pos).func_177230_c());
    }

    static {
        BlockHelper.ICON_ROTATION_MAP[0] = new byte[]{0, 1, 2, 3, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[1] = new byte[]{1, 0, 2, 3, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[2] = new byte[]{3, 2, 0, 1, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[3] = new byte[]{3, 2, 1, 0, 5, 4};
        BlockHelper.ICON_ROTATION_MAP[4] = new byte[]{3, 2, 5, 4, 0, 1};
        BlockHelper.ICON_ROTATION_MAP[5] = new byte[]{3, 2, 4, 5, 1, 0};
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150333_U)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150376_bx)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_180389_cP)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_185771_cX)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150447_bR)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150486_ae)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150476_ad)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150446_ar)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150389_bf)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150390_bg)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150387_bl)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150372_bz)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150485_bF)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150487_bG)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150481_bH)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150370_cb)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_180396_cN)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_185769_cV)] = 1;
    }

    public static final class RotationType {
        public static final int STAIRS = 1;
        public static final int SLAB = 2;
        public static final int CHEST = 3;

        private RotationType() {
        }
    }
}

