/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.ItemHelper;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex, int endIndex) {
        if (stack.func_190926_b()) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (ItemHelper.itemsEqualForCrafting(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].func_190916_E()) {
                int hold = inventory[i].func_77976_d() - inventory[i].func_190916_E();
                if (hold >= stack.func_190916_E()) {
                    inventory[i].func_190917_f(stack.func_190916_E());
                    stack = ItemStack.field_190927_a;
                    return true;
                }
                stack.func_190918_g(hold);
                inventory[i].func_190917_f(hold);
                continue;
            }
            if (!inventory[i].func_190926_b() || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot <= -1) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, startIndex, inventory.length - 1);
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, 0);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate) {
        return InventoryHelper.insertStackIntoInventory(handler, stack, simulate, false);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate, boolean forceEmptySlot) {
        return forceEmptySlot ? ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate) : ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int length, boolean reverse) {
        return InventoryHelper.mergeItemStack(slots, stack, start, length, reverse, true);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int length, boolean r, boolean limit) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int i;
        int iterOrder;
        boolean successful = false;
        int n = iterOrder = !r ? 1 : -1;
        if (stack.func_77985_e()) {
            for (i = !r ? start : length - 1; stack.func_190916_E() > 0 && (!r && i < length || r && i >= start); i += iterOrder) {
                slot = slots.get(i);
                existingStack = slot.func_75211_c();
                if (existingStack.func_190926_b() || !slot.func_75214_a(ItemHelper.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.func_190916_E()))) || !existingStack.func_77973_b().equals(stack.func_77973_b()) || stack.func_77981_g() && stack.func_77952_i() != existingStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                int existingSize = existingStack.func_190916_E() + stack.func_190916_E();
                if (existingSize <= maxStack) {
                    stack.func_190920_e(0);
                    existingStack.func_190920_e(existingSize);
                    slot.func_75215_d(existingStack);
                    successful = true;
                    continue;
                }
                if (existingStack.func_190916_E() >= maxStack) continue;
                stack.func_190918_g(maxStack - existingStack.func_190916_E());
                existingStack.func_190920_e(maxStack);
                slot.func_75215_d(existingStack);
                successful = true;
            }
        }
        if (stack.func_190916_E() > 0) {
            int n2 = i = !r ? start : length - 1;
            while (stack.func_190916_E() > 0 && (!r && i < length || r && i >= start)) {
                slot = slots.get(i);
                existingStack = slot.func_75211_c();
                if (existingStack.func_190926_b() && slot.func_75214_a(ItemHelper.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.func_190916_E())))) {
                    existingStack = stack.func_77979_a(rmv);
                    slot.func_75215_d(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public static ItemStack addToInventory(TileEntity tile, EnumFacing side, ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (InventoryHelper.hasItemHandlerCap(tile, side.func_176734_d())) {
            stack = InventoryHelper.insertStackIntoInventory(InventoryHelper.getItemHandlerCap(tile, side.func_176734_d()), stack, false);
        }
        return stack;
    }

    public static boolean hasItemHandlerCap(TileEntity tileEntity, EnumFacing face) {
        return tileEntity != null && (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face) || tileEntity instanceof ISidedInventory || tileEntity instanceof IInventory);
    }

    public static IItemHandler getItemHandlerCap(TileEntity tileEntity, EnumFacing face) {
        if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        }
        if (tileEntity instanceof ISidedInventory && face != null) {
            return new SidedInvWrapper((ISidedInventory)tileEntity, face);
        }
        if (tileEntity instanceof IInventory) {
            return new InvWrapper((IInventory)tileEntity);
        }
        return EmptyHandler.INSTANCE;
    }

    public static boolean isEmpty(ItemStack[] inventory) {
        for (ItemStack stack : inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

