/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.patches;

import java.util.ListIterator;
import java.util.Map;
import net.minecraft.network.datasync.EntityDataManager;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.foamfix.coremod.common.FoamyArrayBackedDataManagerMap;
import pl.asie.patchy.TransformerFunction;

public class EntityDataManagerPatch
implements TransformerFunction<ClassNode> {
    public static Map<Integer, EntityDataManager.DataEntry<?>> newArrayBackedMap() {
        try {
            Class.forName("it.unimi.dsi.fastutil.ints.IntOpenHashSet");
            return new FoamyArrayBackedDataManagerMap.OneTwelve();
        }
        catch (ClassNotFoundException e) {
            return new FoamyArrayBackedDataManagerMap.OneEleven();
        }
    }

    @Override
    public ClassNode apply(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            ListIterator it = method.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode node2;
                AbstractInsnNode node = (AbstractInsnNode)it.next();
                if (!(node instanceof MethodInsnNode) || node.getOpcode() != 184 || !"com/google/common/collect/Maps".equals(((MethodInsnNode)node).owner) || !"newHashMap".equals(((MethodInsnNode)node).name) || !((node2 = (AbstractInsnNode)it.next()) instanceof FieldInsnNode) || node2.getOpcode() != 181 || !"net/minecraft/network/datasync/EntityDataManager".equals(((FieldInsnNode)node2).owner) || !"entries".equals(((FieldInsnNode)node2).name) && !"field_187234_c".equals(((FieldInsnNode)node2).name)) continue;
                while (!(it.previous() instanceof MethodInsnNode)) {
                }
                it.next();
                it.set(new MethodInsnNode(184, "pl/asie/foamfix/coremod/patches/EntityDataManagerPatch", "newArrayBackedMap", "()Ljava/util/Map;", false));
                it.next();
                System.out.println("Replaced Maps.newHashMap() in " + classNode.name + " " + method.name);
            }
        }
        return classNode;
    }
}

