/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class HUDHandlerFluids
implements IWailaDataProvider {
    static final IWailaDataProvider INSTANCE = new HUDHandlerFluids();

    @Override
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return HUDHandlerFluids.getStackFromLiquid(accessor.getBlockState(), accessor);
    }

    @Override
    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Pair<Fluid, Boolean> fluidPair = HUDHandlerFluids.getFluidFromBlock(accessor.getBlockState());
        String name = null;
        String displayName = String.format(FormattingConfig.fluidFormat, ((Fluid)fluidPair.getLeft()).getLocalizedName(new FluidStack((Fluid)fluidPair.getLeft(), 1000)));
        if (displayName != null && !displayName.endsWith("Unnamed")) {
            name = displayName;
        }
        if (name != null) {
            currenttip.add("\u00a7r" + name);
        }
        if (currenttip.isEmpty()) {
            currenttip.add("\u00a7r" + String.format(FormattingConfig.fluidFormat, "< Unnamed >"));
        } else if (ConfigHandler.instance().getConfig("general", "waila.cfg.metadata", true) && !Strings.isNullOrEmpty((String)FormattingConfig.metaFormat)) {
            currenttip.add(String.format(FormattingConfig.metaFormat, accessor.getBlock().getRegistryName().toString(), accessor.getMetadata()));
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Pair<Fluid, Boolean> fluidPair = HUDHandlerFluids.getFluidFromBlock(accessor.getBlockState());
        String modName = ModIdentification.findModContainer(FluidRegistry.getDefaultFluidName((Fluid)((Fluid)fluidPair.getLeft())).split(":")[0]).getName();
        if (!Strings.isNullOrEmpty((String)FormattingConfig.modNameFormat) && !Strings.isNullOrEmpty((String)modName)) {
            currenttip.add(String.format(FormattingConfig.modNameFormat, modName));
        }
        return currenttip;
    }

    private static ItemStack getStackFromLiquid(IBlockState state, IWailaDataAccessor accessor) {
        Pair<Fluid, Boolean> fluidPair = HUDHandlerFluids.getFluidFromBlock(state);
        Fluid fluid = (Fluid)fluidPair.getLeft();
        boolean vanilla = (Boolean)fluidPair.getRight();
        ItemStack ret = ItemStack.field_190927_a;
        if (fluid != null) {
            if (FluidRegistry.isUniversalBucketEnabled()) {
                ret = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid);
            } else if (vanilla) {
                ret = fluid == FluidRegistry.WATER ? new ItemStack(Items.field_151131_as) : new ItemStack(Items.field_151129_at);
            } else {
                FluidBlockWrapper dummyFluid = new FluidBlockWrapper((IFluidBlock)fluid.getBlock(), accessor.getWorld(), accessor.getPosition());
                ret = FluidUtil.tryFillContainer((ItemStack)new ItemStack(Items.field_151133_ar), (IFluidHandler)dummyFluid, (int)1000, null, (boolean)true).getResult();
            }
        }
        return ret;
    }

    private static Pair<Fluid, Boolean> getFluidFromBlock(IBlockState state) {
        Fluid fluid = null;
        boolean vanilla = false;
        if (state.func_177230_c() instanceof BlockLiquid) {
            BlockStaticLiquid fluidBlock = BlockLiquid.func_176363_b((Material)state.func_185904_a());
            fluid = fluidBlock == Blocks.field_150355_j ? FluidRegistry.WATER : FluidRegistry.LAVA;
            vanilla = true;
        } else if (state.func_177230_c() instanceof IFluidBlock) {
            fluid = ((IFluidBlock)state.func_177230_c()).getFluid();
        }
        return Pair.of(fluid, (Object)vanilla);
    }
}

