/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.minecraft;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.InventoryUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class HUDHandlerChestEntity
implements IWailaEntityProvider {
    public static final IWailaEntityProvider INSTANCE = new HUDHandlerChestEntity();

    @Override
    @Nonnull
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("vanilla.horseinventory")) {
            return currenttip;
        }
        if (!accessor.getNBTData().func_74767_n("chested")) {
            currenttip.add(I18n.func_135052_a((String)"hud.msg.unchested", (Object[])new Object[0]));
            return currenttip;
        }
        if (accessor.getNBTData().func_74764_b("handler")) {
            int handlerSize = accessor.getNBTData().func_74762_e("handlerSize");
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.setSize(handlerSize);
            InventoryUtils.populateInv((IItemHandlerModifiable)itemHandler, accessor.getNBTData().func_150295_c("handler", 10));
            String renderString = "";
            int drawnCount = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                String name = stack.func_77973_b().getRegistryName().toString();
                if (drawnCount >= 5) {
                    currenttip.add(renderString);
                    renderString = "";
                    drawnCount = 0;
                }
                String nbt = "";
                if (stack.func_77942_o()) {
                    nbt = stack.func_77978_p().toString();
                }
                renderString = renderString + SpecialChars.getRenderString("waila.stack", "1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), nbt);
                ++drawnCount;
            }
            currenttip.add(renderString);
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        ContainerHorseChest horseChest = (ContainerHorseChest)ReflectionHelper.getPrivateValue(AbstractHorse.class, (Object)((AbstractChestHorse)ent), (String[])new String[]{"horseChest", "field_110296_bG"});
        InvWrapper itemHandler = new InvWrapper((IInventory)horseChest);
        tag.func_74782_a("handler", (NBTBase)InventoryUtils.invToNBT((IItemHandler)itemHandler, player.func_70093_af() ? itemHandler.getSlots() : 5));
        tag.func_74768_a("handlerSize", itemHandler.getSlots());
        tag.func_74757_a("chested", ((AbstractChestHorse)ent).func_190695_dh());
        return tag;
    }
}

