/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.OverlayConfig;
import net.minecraft.client.gui.GuiTextField;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class ColorConfig {
    public static final List<ColorConfig> ACTIVE_CONFIGS = new ArrayList<ColorConfig>();
    private static final ColorConfig DEFAULT_VANILLA = new ColorConfig("cfg.theme.vanilla", null, null, null, null);
    private static final ColorConfig DEFAULT_DARK = new ColorConfig("cfg.theme.dark", Color.decode("#131313"), Color.decode("#383838"), Color.decode("#242424"), null);
    private final String name;
    private final Color background;
    private final Color gradientTop;
    private final Color gradientBottom;
    private final Color font;

    public ColorConfig(String name, Color background, Color gradientTop, Color gradientBottom, Color font) {
        this.name = name;
        this.background = background;
        this.gradientTop = gradientTop;
        this.gradientBottom = gradientBottom;
        this.font = font;
    }

    public String getName() {
        return this.name != null ? this.name : RandomStringUtils.random((int)10);
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getGradientTop() {
        return this.gradientTop;
    }

    public Color getGradientBottom() {
        return this.gradientBottom;
    }

    public Color getFont() {
        return this.font;
    }

    public void apply(GuiTextField background, GuiTextField gradientTop, GuiTextField gradientBottom, GuiTextField font) {
        background.func_146180_a(OverlayConfig.toHex(this.getBackground()));
        gradientTop.func_146180_a(OverlayConfig.toHex(this.getGradientTop()));
        gradientBottom.func_146180_a(OverlayConfig.toHex(this.getGradientBottom()));
        font.func_146180_a(OverlayConfig.toHex(this.getFont()));
    }

    public static void init() {
        try {
            if (!Waila.themeDir.exists() && Waila.themeDir.mkdirs()) {
                String vanillaJson = OverlayConfig.GSON.toJson((Object)DEFAULT_VANILLA);
                FileWriter vanillaWriter = new FileWriter(new File(Waila.themeDir, "vanilla.json"));
                vanillaWriter.write(vanillaJson);
                vanillaWriter.close();
                String darkJson = OverlayConfig.GSON.toJson((Object)DEFAULT_DARK);
                FileWriter darkWriter = new FileWriter(new File(Waila.themeDir, "dark.json"));
                darkWriter.write(darkJson);
                darkWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File[] themeFiles = Waila.themeDir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (themeFiles != null) {
            try {
                for (File file : themeFiles) {
                    ACTIVE_CONFIGS.add((ColorConfig)OverlayConfig.GSON.fromJson((Reader)new FileReader(file), ColorConfig.class));
                }
            }
            catch (Exception e) {
                Waila.LOGGER.error("Error parsing theme files");
            }
        }
        ACTIVE_CONFIGS.sort((config1, config2) -> config1.getName().equalsIgnoreCase("cfg.theme.vanilla") ? -1 : 0);
    }

    public static class Serializer
    implements JsonSerializer<ColorConfig>,
    JsonDeserializer<ColorConfig> {
        public ColorConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            String background = this.getOptionalString(json, "background", "#100010");
            String gradientTop = this.getOptionalString(json, "gradientTop", "#5000FF");
            String gradientBottom = this.getOptionalString(json, "gradientBottom", "#28007F");
            String font = this.getOptionalString(json, "font", "#A0A0A0");
            return new ColorConfig(name, OverlayConfig.fromHex(background), OverlayConfig.fromHex(gradientTop), OverlayConfig.fromHex(gradientBottom), OverlayConfig.fromHex(font));
        }

        public JsonElement serialize(ColorConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", src.getName() != null ? src.getName() : RandomStringUtils.random((int)10));
            jsonObject.addProperty("background", src.getBackground() != null ? OverlayConfig.toHex(src.getBackground()) : "#100010");
            jsonObject.addProperty("gradientTop", src.getGradientTop() != null ? OverlayConfig.toHex(src.getGradientTop()) : "#5000FF");
            jsonObject.addProperty("gradientBottom", src.getGradientBottom() != null ? OverlayConfig.toHex(src.getGradientBottom()) : "#28007F");
            jsonObject.addProperty("font", src.getFont() != null ? OverlayConfig.toHex(src.getFont()) : "#A0A0A0");
            return jsonObject;
        }

        private String getOptionalString(JsonElement jsonElement, String memberName, String default_) {
            if (jsonElement.getAsJsonObject().has(memberName)) {
                return jsonElement.getAsJsonObject().get(memberName).getAsString();
            }
            return default_;
        }
    }
}

