/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.IWailaCommonAccessor;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class DisplayUtil {
    private static final String[] NUM_SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    protected static RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    private static FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;

    public static int getDisplayWidth(String s) {
        String[] renderSplit;
        if (s == null || s.equals("")) {
            return 0;
        }
        int width = 0;
        for (String render : renderSplit = s.split(SpecialChars.WailaSplitter)) {
            Matcher renderMatcher = SpecialChars.patternRender.matcher(render);
            while (renderMatcher.find()) {
                IWailaTooltipRenderer renderer = ModuleRegistrar.instance().getTooltipRenderer(renderMatcher.group("name"));
                if (renderer == null) continue;
                width += renderer.getSize((String[])renderMatcher.group((String)"args").split((String)"\\+,"), (IWailaCommonAccessor)DataAccessorCommon.instance).width;
                s = s.replace(render, "");
            }
        }
        Matcher iconMatcher = SpecialChars.patternIcon.matcher(s);
        while (iconMatcher.find()) {
            width += 8;
        }
        String stripped = DisplayUtil.stripSymbols(s);
        return width += fontRendererObj.func_78256_a(stripped);
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        return new Dimension(res.func_78326_a(), res.func_78328_b());
    }

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.enable3DRender();
        try {
            renderItem.func_180450_b(stack, x, y);
            ItemStack overlayRender = stack.func_77946_l();
            overlayRender.func_190920_e(1);
            renderItem.func_180453_a(fontRendererObj, overlayRender, x, y, null);
            DisplayUtil.renderStackSize(fontRendererObj, stack, x, y);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void renderStackSize(FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        if (!stack.func_190926_b() && stack.func_190916_E() != 1) {
            String s = DisplayUtil.shortHandNumber(stack.func_190916_E());
            if (stack.func_190916_E() < 1) {
                s = TextFormatting.RED + String.valueOf(stack.func_190916_E());
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            fr.func_175063_a(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }

    private static String shortHandNumber(Number number) {
        String shorthand = new DecimalFormat("##0E0").format(number);
        shorthand = shorthand.replaceAll("E[0-9]", NUM_SUFFIXES[Character.getNumericValue(shorthand.charAt(shorthand.length() - 1)) / 3]);
        while (shorthand.length() > 4 || shorthand.matches("[0-9]+\\.[a-z]")) {
            shorthand = shorthand.substring(0, shorthand.length() - 2) + shorthand.substring(shorthand.length() - 1);
        }
        return shorthand;
    }

    public static void enable3DRender() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static void enable2DRender() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float zLevel = 0.0f;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(left + right), (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + bottom), (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        buffer.func_181662_b((double)(left + right), (double)(top + bottom), (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + th) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + tw) * f), (double)((float)(textureY + th) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(textureX + tw) * f), (double)((float)textureY * f1)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRendererObj.func_175063_a(text, (float)x, (float)y, colour);
        } else {
            fontRendererObj.func_78276_b(text, x, y, colour);
        }
    }

    public static List<String> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        namelist.set(0, itemstack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (String)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<String> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return String.format(FormattingConfig.blockFormat, list.get(0));
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }
}

