/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAtomicReconstructor
extends BlockContainerBase
implements IHudDisplay {
    public static final int NAME_FLAVOR_AMOUNTS_1 = 12;
    public static final int NAME_FLAVOR_AMOUNTS_2 = 14;

    public BlockAtomicReconstructor(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(10.0f);
        this.func_149752_b(80.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        TileEntityAtomicReconstructor reconstructor;
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.tryToggleRedstone(world, pos, player)) {
            return true;
        }
        if (!world.field_72995_K && (reconstructor = (TileEntityAtomicReconstructor)world.func_175625_s(pos)) != null) {
            if (StackUtil.isValid(heldItem)) {
                Item item = heldItem.func_77973_b();
                if (item instanceof ILensItem && !StackUtil.isValid(reconstructor.slots.getStackInSlot(0))) {
                    ItemStack toPut = heldItem.func_77946_l();
                    toPut = StackUtil.setStackSize(toPut, 1);
                    reconstructor.slots.setStackInSlot(0, toPut);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                } else if (ConfigIntValues.ELEVEN.getValue() == 11 && item == Items.field_151086_cn) {
                    ++reconstructor.counter;
                    reconstructor.func_70296_d();
                }
            } else {
                ItemStack slot = reconstructor.slots.getStackInSlot(0);
                if (StackUtil.isValid(slot)) {
                    player.func_184611_a(hand, slot.func_77946_l());
                    reconstructor.slots.setStackInSlot(0, StackUtil.getNull());
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityAtomicReconstructor();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, RayTraceResult posHit, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a());
        if (tile instanceof TileEntityAtomicReconstructor) {
            String strg;
            ItemStack slot = ((TileEntityAtomicReconstructor)tile).slots.getStackInSlot(0);
            if (!StackUtil.isValid(slot)) {
                strg = StringUtil.localize("info.actuallyadditions.noLens");
            } else {
                strg = slot.func_77973_b().func_77653_i(slot);
                AssetUtil.renderStackToGui(slot, resolution.func_78326_a() / 2 + 15, resolution.func_78328_b() / 2 - 19, 1.0f);
            }
            minecraft.field_71466_p.func_175063_a(TextFormatting.YELLOW + "" + TextFormatting.ITALIC + strg, (float)(resolution.func_78326_a() / 2 + 35), (float)(resolution.func_78328_b() / 2 - 15), 0xFFFFFF);
        }
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock((Block)this);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int rotation = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player).ordinal();
        world.func_180501_a(pos, this.func_176203_a(rotation), 2);
        super.func_180633_a(world, pos, state, player, stack);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return this.func_185499_a(state, mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        int i = 0;
        if (t instanceof TileEntityAtomicReconstructor) {
            i = ((TileEntityAtomicReconstructor)t).getEnergy();
        }
        return MathHelper.func_76125_a((int)(i / 20000), (int)0, (int)15);
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        private long lastSysTime;
        private int toPick1;
        private int toPick2;

        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(false);
            this.func_77656_e(0);
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return this.func_77658_a();
        }

        @Override
        public int func_77647_b(int damage) {
            return damage;
        }

        public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
            long sysTime = System.currentTimeMillis();
            if (this.lastSysTime + 3000L < sysTime) {
                this.lastSysTime = sysTime;
                if (world != null) {
                    this.toPick1 = world.field_73012_v.nextInt(12) + 1;
                    this.toPick2 = world.field_73012_v.nextInt(14) + 1;
                }
            }
            String base = "tile.actuallyadditions." + ((BlockAtomicReconstructor)this.field_150939_a).getBaseName() + ".info.";
            tooltip.add(StringUtil.localize(base + "1." + this.toPick1) + " " + StringUtil.localize(base + "2." + this.toPick2));
        }
    }
}

