/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTinyTorch
extends BlockBase {
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 0.3125, 0.5625);
    private static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB(0.4375, 0.25, 0.8125, 0.5625, 0.5625, 1.0);
    private static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB(0.4375, 0.25, 0.0, 0.5625, 0.5625, 0.1875);
    private static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB(0.8125, 0.25, 0.4375, 1.0, 0.5625, 0.5625);
    private static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.4375, 0.1875, 0.5625, 0.5625);

    public BlockTinyTorch(String name) {
        super(Material.field_151594_q, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.8f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : BlockTorch.field_176596_a.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && worldIn.isSideSolid(blockpos, facing, true) || facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos otherPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a);
        EnumFacing.Axis axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        boolean flag = false;
        if (axis.func_176722_c() && !worldIn.isSideSolid(pos.func_177972_a(enumfacing1), enumfacing, true)) {
            flag = true;
        } else if (axis.func_176720_b() && !this.canPlaceOn(worldIn, pos.func_177972_a(enumfacing1))) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextBoolean()) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)BlockTorch.field_176596_a);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.4;
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (enumfacing.func_176740_k().func_176722_c()) {
                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.35 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.35 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.35 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.35 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            } else {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            default: {
                i |= 5;
            }
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockTorch.field_176596_a});
    }
}

