/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemFillingWand
extends ItemEnergy {
    public ItemFillingWand(String name) {
        super(500000, 1000, name);
    }

    private static boolean removeFittingItem(IBlockState state, EntityPlayer player) {
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(block, 1, block.func_180651_a(state));
        if (StackUtil.isValid(stack)) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (!StackUtil.isValid(slot) || !slot.func_77969_a(stack)) continue;
                if (!StackUtil.isValid(slot = StackUtil.addStackSize(slot, -1))) {
                    player.field_71071_by.func_70299_a(i, StackUtil.getNull());
                }
                return true;
            }
        }
        return false;
    }

    private static void saveBlock(IBlockState state, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("state", Block.func_176210_f((IBlockState)state));
    }

    private static IBlockState loadBlock(ItemStack stack) {
        if (stack.func_77942_o()) {
            return Block.func_176220_d((int)stack.func_77978_p().func_74762_e("state"));
        }
        return null;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_184605_cv() <= 0) {
            if (player.func_70093_af()) {
                IBlockState state = world.func_180495_p(pos);
                ItemFillingWand.saveBlock(state, stack);
                return EnumActionResult.SUCCESS;
            }
            if (ItemFillingWand.loadBlock(stack) != null) {
                NBTTagCompound compound;
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if ((compound = stack.func_77978_p()).func_74762_e("CurrX") == 0 && compound.func_74762_e("CurrY") == 0 && compound.func_74762_e("CurrZ") == 0) {
                    compound.func_74768_a("FirstX", pos.func_177958_n());
                    compound.func_74768_a("FirstY", pos.func_177956_o());
                    compound.func_74768_a("FirstZ", pos.func_177952_p());
                    player.func_184598_c(hand);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            RayTraceResult result;
            boolean clear = true;
            if (entity instanceof EntityPlayer && (result = WorldUtil.getNearestBlockWithDefaultReachDistance(world, (EntityPlayer)entity)) != null && result.func_178782_a() != null) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound compound = stack.func_77978_p();
                BlockPos pos = result.func_178782_a();
                compound.func_74768_a("SecondX", pos.func_177958_n());
                compound.func_74768_a("SecondY", pos.func_177956_o());
                compound.func_74768_a("SecondZ", pos.func_177952_p());
                clear = false;
            }
            if (clear) {
                ItemPhantomConnector.clearStorage(stack, "FirstX", "FirstY", "FirstZ");
            }
        }
        super.func_77615_a(stack, world, entity, timeLeft);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!world.field_72995_K) {
            boolean shouldClear = false;
            if (isSelected) {
                if (entity instanceof EntityPlayer && stack.func_77942_o()) {
                    EntityPlayer player = (EntityPlayer)entity;
                    boolean creative = player.field_71075_bZ.field_75098_d;
                    NBTTagCompound compound = stack.func_77978_p();
                    BlockPos firstPos = new BlockPos(compound.func_74762_e("FirstX"), compound.func_74762_e("FirstY"), compound.func_74762_e("FirstZ"));
                    BlockPos secondPos = new BlockPos(compound.func_74762_e("SecondX"), compound.func_74762_e("SecondY"), compound.func_74762_e("SecondZ"));
                    if (!BlockPos.field_177992_a.equals((Object)firstPos) && !BlockPos.field_177992_a.equals((Object)secondPos)) {
                        int energyUse = 1500;
                        IBlockState replaceState = ItemFillingWand.loadBlock(stack);
                        if (replaceState != null && (creative || this.getEnergyStored(stack) >= energyUse)) {
                            int currZ;
                            int currY;
                            int lowestX = Math.min(firstPos.func_177958_n(), secondPos.func_177958_n());
                            int lowestY = Math.min(firstPos.func_177956_o(), secondPos.func_177956_o());
                            int lowestZ = Math.min(firstPos.func_177952_p(), secondPos.func_177952_p());
                            int currX = compound.func_74762_e("CurrX");
                            BlockPos pos = new BlockPos(lowestX + currX, lowestY + (currY = compound.func_74762_e("CurrY")), lowestZ + (currZ = compound.func_74762_e("CurrZ")));
                            IBlockState state = world.func_180495_p(pos);
                            if (state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && replaceState.func_177230_c().func_176196_c(world, pos)) {
                                if (creative || ItemFillingWand.removeFittingItem(replaceState, player)) {
                                    world.func_180501_a(pos, replaceState, 2);
                                    SoundType sound = replaceState.func_177230_c().getSoundType(replaceState, world, pos, (Entity)player);
                                    world.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                                    if (!creative) {
                                        this.extractEnergyInternal(stack, energyUse, false);
                                    }
                                } else {
                                    shouldClear = true;
                                }
                            }
                            int distX = Math.abs(secondPos.func_177958_n() - firstPos.func_177958_n());
                            int distY = Math.abs(secondPos.func_177956_o() - firstPos.func_177956_o());
                            int distZ = Math.abs(secondPos.func_177952_p() - firstPos.func_177952_p());
                            if (++currX > distX) {
                                currX = 0;
                                if (++currY > distY) {
                                    currY = 0;
                                    if (++currZ > distZ) {
                                        shouldClear = true;
                                    }
                                }
                            }
                            if (!shouldClear) {
                                compound.func_74768_a("CurrX", currX);
                                compound.func_74768_a("CurrY", currY);
                                compound.func_74768_a("CurrZ", currZ);
                            }
                        } else {
                            shouldClear = true;
                        }
                    }
                }
            } else {
                shouldClear = true;
            }
            if (shouldClear) {
                ItemPhantomConnector.clearStorage(stack, "FirstX", "FirstY", "FirstZ", "SecondX", "SecondY", "SecondZ", "CurrX", "CurrY", "CurrZ");
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        Block block;
        ItemStack blockStack;
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        String display = StringUtil.localize("tooltip.actuallyadditions.item_filling_wand.selectedBlock.none");
        IBlockState state = ItemFillingWand.loadBlock(stack);
        if (state != null && StackUtil.isValid(blockStack = new ItemStack(block = state.func_177230_c(), 1, block.func_176201_c(state)))) {
            display = blockStack.func_82833_r();
        }
        tooltip.add(String.format("%s: %s", StringUtil.localize("tooltip.actuallyadditions.item_filling_wand.selectedBlock"), display));
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

