/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCrafter;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiGrinder;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.jei.booklet.BookletRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.booklet.BookletRecipeWrapper;
import de.ellpeck.actuallyadditions.mod.jei.coffee.CoffeeMachineRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.coffee.CoffeeMachineRecipeWrapper;
import de.ellpeck.actuallyadditions.mod.jei.crusher.CrusherRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.crusher.CrusherRecipeWrapper;
import de.ellpeck.actuallyadditions.mod.jei.empowerer.EmpowererRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.empowerer.EmpowererRecipeWrapper;
import de.ellpeck.actuallyadditions.mod.jei.reconstructor.ReconstructorRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.reconstructor.ReconstructorRecipeWrapper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIActuallyAdditionsPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new CoffeeMachineRecipeCategory(helpers.getGuiHelper()), new CrusherRecipeCategory(helpers.getGuiHelper()), new ReconstructorRecipeCategory(helpers.getGuiHelper()), new EmpowererRecipeCategory(helpers.getGuiHelper()), new BookletRecipeCategory(helpers.getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        registry.handleRecipes(IBookletPage.class, BookletRecipeWrapper::new, "actuallyadditions.booklet");
        registry.handleRecipes(CoffeeIngredient.class, CoffeeMachineRecipeWrapper::new, "actuallyadditions.coffee");
        registry.handleRecipes(CrusherRecipe.class, CrusherRecipeWrapper::new, "actuallyadditions.crushing");
        registry.handleRecipes(LensConversionRecipe.class, ReconstructorRecipeWrapper::new, "actuallyadditions.reconstructor");
        registry.handleRecipes(EmpowererRecipe.class, EmpowererRecipeWrapper::new, "actuallyadditions.empowerer");
        registry.addRecipes(ActuallyAdditionsAPI.BOOKLET_PAGES_WITH_ITEM_OR_FLUID_DATA, "actuallyadditions.booklet");
        registry.addRecipes(ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS, "actuallyadditions.coffee");
        registry.addRecipes(ActuallyAdditionsAPI.CRUSHER_RECIPES, "actuallyadditions.crushing");
        registry.addRecipes(ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES, "actuallyadditions.reconstructor");
        registry.addRecipes(ActuallyAdditionsAPI.EMPOWERER_RECIPES, "actuallyadditions.empowerer");
        registry.addRecipeClickArea(GuiCoffeeMachine.class, 53, 42, 22, 16, new String[]{"actuallyadditions.coffee"});
        registry.addRecipeClickArea(GuiGrinder.class, 80, 40, 24, 22, new String[]{"actuallyadditions.crushing"});
        registry.addRecipeClickArea(GuiGrinder.GuiGrinderDouble.class, 51, 40, 74, 22, new String[]{"actuallyadditions.crushing"});
        registry.addRecipeClickArea(GuiFurnaceDouble.class, 51, 40, 74, 22, new String[]{"minecraft.smelting"});
        IIngredientBlacklist blacklist = helpers.getIngredientBlacklist();
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitBlocks.blockRice));
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitBlocks.blockCanola));
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitBlocks.blockFlax));
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitBlocks.blockCoffee));
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitBlocks.blockWildPlant, 1, Short.MAX_VALUE));
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitBlocks.blockColoredLampOn, 1, Short.MAX_VALUE));
        blacklist.addIngredientToBlacklist((Object)new ItemStack(InitItems.itemMisc, 1, TheMiscItems.YOUTUBE_ICON.ordinal()));
        IRecipeTransferRegistry transfer = registry.getRecipeTransferRegistry();
        transfer.addRecipeTransferHandler(ContainerCrafter.class, "minecraft.crafting", 1, 9, 10, 36);
        registry.addRecipeCatalyst((Object)new ItemStack(InitItems.itemCrafterOnAStick), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitBlocks.blockFurnaceDouble), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitBlocks.blockGrinder), new String[]{"actuallyadditions.crushing"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitBlocks.blockGrinderDouble), new String[]{"actuallyadditions.crushing"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitBlocks.blockCoffeeMachine), new String[]{"actuallyadditions.coffee"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitBlocks.blockAtomicReconstructor), new String[]{"actuallyadditions.reconstructor"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitBlocks.blockEmpowerer), new String[]{"actuallyadditions.empowerer"});
        registry.addRecipeCatalyst((Object)new ItemStack(InitItems.itemBooklet), new String[]{"actuallyadditions.booklet"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

