/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei.booklet;

import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.jei.RecipeWrapperWithButton;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class BookletRecipeWrapper
extends RecipeWrapperWithButton {
    public final IBookletPage thePage;

    public BookletRecipeWrapper(IBookletPage page) {
        this.thePage = page;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        this.thePage.getItemStacksForPage(itemList);
        ingredients.setInputs(ItemStack.class, itemList);
        ingredients.setOutputs(ItemStack.class, itemList);
        ArrayList<FluidStack> fluidList = new ArrayList<FluidStack>();
        this.thePage.getFluidStacksForPage(fluidList);
        ingredients.setInputs(FluidStack.class, fluidList);
        ingredients.setOutputs(FluidStack.class, fluidList);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        List header = minecraft.field_71466_p.func_78271_c(StringUtil.localize("container.nei.actuallyadditions.booklet.header").replaceAll("<item>", TextFormatting.BLUE + "").replaceAll("<r>", TextFormatting.BLACK + ""), 150);
        for (int i = 0; i < header.size(); ++i) {
            minecraft.field_71466_p.func_175065_a((String)header.get(i), 0.0f, (float)(17 + i * (minecraft.field_71466_p.field_78288_b + 1)), 0, false);
        }
        int maxLines = 4;
        IBookletChapter chapter = this.thePage.getChapter();
        String aText = chapter.getAllPages()[0].getInfoText();
        List text = minecraft.field_71466_p.func_78271_c(aText != null ? aText : TextFormatting.DARK_RED + StringUtil.localize("container.nei.actuallyadditions.booklet.noText"), 150);
        for (int i = 0; i < Math.min(maxLines, text.size()); ++i) {
            minecraft.field_71466_p.func_175065_a((String)text.get(i) + (i == maxLines - 1 && text.size() > maxLines ? TextFormatting.RESET + "" + TextFormatting.BLACK + "..." : ""), 0.0f, (float)(41 + i * (minecraft.field_71466_p.field_78288_b + 1)), 0, false);
        }
        minecraft.field_71466_p.func_175065_a(TextFormatting.ITALIC + chapter.getLocalizedName(), 25.0f, 85.0f, 0, false);
        minecraft.field_71466_p.func_175065_a(TextFormatting.ITALIC + "Page " + (chapter.getPageIndex(this.thePage) + 1), 25.0f, 95.0f, 0, false);
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
    }

    @Override
    public int getButtonX() {
        return 0;
    }

    @Override
    public int getButtonY() {
        return 84;
    }

    @Override
    public IBookletPage getPage() {
        return this.thePage;
    }
}

