/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer.DefaultFarmerBehavior;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MelonPumpkinFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, World world, BlockPos pos, IFarmer farmer) {
        int use = 350;
        if (farmer.getEnergy() >= use * 2 && StackUtil.isValid(seed)) {
            boolean isPumpkin;
            Item seedItem = seed.func_77973_b();
            boolean bl = isPumpkin = seedItem == Items.field_151080_bb;
            if (isPumpkin || seedItem == Items.field_151081_bc) {
                IBlockState toPlant;
                if (pos.func_177958_n() % 2 == 0 == (pos.func_177952_p() % 2 == 0) && DefaultFarmerBehavior.defaultPlant(world, pos, toPlant = (isPumpkin ? Blocks.field_150393_bb : Blocks.field_150394_bc).func_176223_P(), farmer, use)) {
                    return FarmerResult.SUCCESS;
                }
                return FarmerResult.STOP_PROCESSING;
            }
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(World world, BlockPos pos, IFarmer farmer) {
        IBlockState state;
        Block block;
        int use = 500;
        if (farmer.getEnergy() >= use && ((block = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150423_aK || block == Blocks.field_150440_ba)) {
            NonNullList drops = NonNullList.func_191196_a();
            block.getDrops(drops, (IBlockAccess)world, pos, state, 0);
            if (drops != null && !drops.isEmpty() && farmer.addToOutputInventory((List<ItemStack>)drops, false)) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                world.func_175698_g(pos);
                farmer.extractEnergy(use);
                farmer.addToOutputInventory((List<ItemStack>)drops, true);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.STOP_PROCESSING;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

