/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.special;

import de.ellpeck.actuallyadditions.mod.misc.special.RenderSpecial;
import de.ellpeck.actuallyadditions.mod.misc.special.ThreadSpecialFetcher;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SpecialRenderInit {
    public static final HashMap<String, RenderSpecial> SPECIAL_LIST = new HashMap();

    public SpecialRenderInit() {
        new ThreadSpecialFetcher();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void parse(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            int meta;
            String[] values = properties.getProperty(key).split("@");
            if (values.length <= 0) continue;
            String itemName = values[0];
            try {
                meta = Integer.parseInt(values[1]);
            }
            catch (Exception e) {
                meta = 0;
            }
            ResourceLocation resLoc = new ResourceLocation(itemName);
            ItemStack stack = SpecialRenderInit.findItem(resLoc, meta);
            if (!StackUtil.isValid(stack)) {
                String convertedItemName = "";
                for (char c : itemName.toCharArray()) {
                    if (Character.isUpperCase(c)) {
                        convertedItemName = convertedItemName + "_";
                        convertedItemName = convertedItemName + Character.toLowerCase(c);
                        continue;
                    }
                    convertedItemName = convertedItemName + c;
                }
                stack = SpecialRenderInit.findItem(new ResourceLocation(convertedItemName), meta);
            }
            if (!StackUtil.isValid(stack)) continue;
            SPECIAL_LIST.put(key.toLowerCase(Locale.ROOT), new RenderSpecial(stack));
        }
    }

    private static ItemStack findItem(ResourceLocation resLoc, int meta) {
        Block block;
        if (Item.field_150901_e.func_148741_d((Object)resLoc)) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)resLoc);
            if (item != null) {
                return new ItemStack(item, 1, meta);
            }
        } else if (Block.field_149771_c.func_148741_d((Object)resLoc) && (block = (Block)Block.field_149771_c.func_82594_a((Object)resLoc)) != null) {
            return new ItemStack(block, 1, meta);
        }
        return StackUtil.getNull();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        RenderSpecial render;
        String lower;
        String name;
        if (event.getEntityPlayer() != null && (name = event.getEntityPlayer().func_70005_c_()) != null && SPECIAL_LIST.containsKey(lower = name.toLowerCase(Locale.ROOT)) && (render = SPECIAL_LIST.get(lower)) != null) {
            render.render(event.getEntityPlayer(), event.getPartialRenderTick());
        }
    }
}

