/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.recipe;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class CrusherRecipeRegistry {
    public static final ArrayList<SearchCase> SEARCH_CASES = new ArrayList();

    public static void registerFinally() {
        ArrayList<String> oresNoResult = new ArrayList<String>();
        int recipeStartedAt = ActuallyAdditionsAPI.CRUSHER_RECIPES.size();
        for (String ore : OreDictionary.getOreNames()) {
            if (CrusherRecipeRegistry.hasException(ore)) continue;
            for (SearchCase theCase : SEARCH_CASES) {
                if (ore.length() <= theCase.theCase.length() || !ore.substring(0, theCase.theCase.length()).equals(theCase.theCase)) continue;
                String output = theCase.resultPreString + ore.substring(theCase.theCase.length());
                NonNullList outputs = OreDictionary.getOres((String)output, (boolean)false);
                if (ActuallyAdditionsAPI.methodHandler.addCrusherRecipes((List<ItemStack>)OreDictionary.getOres((String)ore, (boolean)false), outputs.isEmpty() ? StackUtil.getNull() : (ItemStack)outputs.get(0), theCase.resultAmount, StackUtil.getNull(), 0, 0) || oresNoResult.contains(ore)) continue;
                oresNoResult.add(ore);
            }
        }
        ArrayList<String> addedRecipes = new ArrayList<String>();
        for (int i = recipeStartedAt; i < ActuallyAdditionsAPI.CRUSHER_RECIPES.size(); ++i) {
            CrusherRecipe recipe = ActuallyAdditionsAPI.CRUSHER_RECIPES.get(i);
            addedRecipes.add(recipe.inputStack + " -> " + recipe.outputOneStack);
        }
        ModUtil.LOGGER.info("Added " + addedRecipes.size() + " Crusher Recipes automatically: " + addedRecipes);
        ModUtil.LOGGER.warn("Couldn't add " + oresNoResult.size() + " Crusher Recipes automatically, either because the inputs were missing outputs, or because they exist already: " + oresNoResult);
    }

    public static boolean hasBlacklistedOutput(ItemStack output, String[] config) {
        Item item;
        if (StackUtil.isValid(output) && (item = output.func_77973_b()) != null) {
            String reg = item.getRegistryName().toString();
            String[] stringArray = config;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String conf;
                String confReg = conf = stringArray[i];
                int meta = 0;
                if (conf.contains("@")) {
                    try {
                        String[] split = conf.split("@");
                        confReg = split[0];
                        meta = Integer.parseInt(split[1]);
                    }
                    catch (Exception e) {
                        ModUtil.LOGGER.warn("A config option appears to be incorrect: The entry " + conf + " can't be parsed!");
                    }
                }
                if (!reg.equals(confReg) || output.func_77952_i() != meta) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean hasException(String ore) {
        for (String conf : ConfigStringListValues.CRUSHER_RECIPE_EXCEPTIONS.getValue()) {
            if (!conf.equals(ore)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getOutputOnes(ItemStack input) {
        CrusherRecipe recipe = CrusherRecipeRegistry.getRecipeFromInput(input);
        return recipe == null ? StackUtil.getNull() : recipe.outputOneStack;
    }

    public static CrusherRecipe getRecipeFromInput(ItemStack input) {
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.CRUSHER_RECIPES) {
            if (!ItemUtil.areItemsEqual(recipe.inputStack, input, true)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack getOutputTwos(ItemStack input) {
        CrusherRecipe recipe = CrusherRecipeRegistry.getRecipeFromInput(input);
        return recipe == null ? StackUtil.getNull() : recipe.outputTwoStack;
    }

    public static int getOutputTwoChance(ItemStack input) {
        CrusherRecipe recipe = CrusherRecipeRegistry.getRecipeFromInput(input);
        return recipe == null ? -1 : recipe.outputTwoChance;
    }

    public static class SearchCase {
        final String theCase;
        final int resultAmount;
        final String resultPreString;

        public SearchCase(String theCase, int resultAmount) {
            this(theCase, resultAmount, "dust");
        }

        public SearchCase(String theCase, int resultAmount, String resultPreString) {
            this.theCase = theCase;
            this.resultAmount = resultAmount;
            this.resultPreString = resultPreString;
        }
    }
}

