/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityBreaker
extends TileEntityInventoryBase {
    public boolean isPlacer;
    private int currentTime;

    public TileEntityBreaker(int slots, String name) {
        super(slots, name);
    }

    public TileEntityBreaker() {
        super(9, "breaker");
        this.isPlacer = false;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!(this.field_145850_b.field_72995_K || this.isRedstonePowered || this.isPulseMode)) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 15;
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return this.isPlacer;
    }

    private void doWork() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing sideToManipulate = WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state));
        BlockPos coordsBlock = this.field_174879_c.func_177972_a(sideToManipulate);
        IBlockState stateToBreak = this.field_145850_b.func_180495_p(coordsBlock);
        Block blockToBreak = stateToBreak.func_177230_c();
        if (!(this.isPlacer || blockToBreak == null || this.field_145850_b.func_175623_d(coordsBlock) || blockToBreak instanceof BlockLiquid || blockToBreak instanceof IFluidBlock || !(stateToBreak.func_185887_b(this.field_145850_b, coordsBlock) >= 0.0f))) {
            NonNullList drops = NonNullList.func_191196_a();
            blockToBreak.getDrops(drops, (IBlockAccess)this.field_145850_b, coordsBlock, stateToBreak, 0);
            float chance = WorldUtil.fireFakeHarvestEventsForDropChance((List<ItemStack>)drops, this.field_145850_b, coordsBlock);
            if (chance > 0.0f && this.field_145850_b.field_73012_v.nextFloat() <= chance && WorldUtil.addToInventory(this.slots, (List<ItemStack>)drops, false)) {
                this.field_145850_b.func_175718_b(2001, coordsBlock, Block.func_176210_f((IBlockState)stateToBreak));
                this.field_145850_b.func_175698_g(coordsBlock);
                WorldUtil.addToInventory(this.slots, (List<ItemStack>)drops, true);
                this.func_70296_d();
            }
        } else if (this.isPlacer) {
            int theSlot = WorldUtil.findFirstFilledSlot(this.slots);
            this.slots.setStackInSlot(theSlot, WorldUtil.useItemAtSide(sideToManipulate, this.field_145850_b, this.field_174879_c, this.slots.getStackInSlot(theSlot)));
            if (!StackUtil.isValid(this.slots.getStackInSlot(theSlot))) {
                this.slots.setStackInSlot(theSlot, StackUtil.getNull());
            }
        }
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

