/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CompostRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCompost
extends TileEntityInventoryBase {
    public int conversionTime;

    public TileEntityCompost() {
        super(1, "compost");
    }

    public static CompostRecipe getRecipeForInput(ItemStack input) {
        if (StackUtil.isValid(input)) {
            for (CompostRecipe recipe : ActuallyAdditionsAPI.COMPOST_RECIPES) {
                if (!input.func_77969_a(recipe.input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("ConversionTime", this.conversionTime);
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.conversionTime = compound.func_74762_e("ConversionTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean theFlag;
            boolean bl = theFlag = this.conversionTime > 0;
            if (StackUtil.isValid(this.slots.getStackInSlot(0))) {
                CompostRecipe recipe = TileEntityCompost.getRecipeForInput(this.slots.getStackInSlot(0));
                if (recipe != null) {
                    ++this.conversionTime;
                    if (this.conversionTime >= 3000) {
                        ItemStack output = recipe.output.func_77946_l();
                        this.slots.setStackInSlot(0, StackUtil.setStackSize(output, StackUtil.getStackSize(this.slots.getStackInSlot(0))));
                        this.conversionTime = 0;
                        this.func_70296_d();
                    }
                } else {
                    this.conversionTime = 0;
                }
            }
            if (theFlag != this.conversionTime > 0) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return TileEntityCompost.getRecipeForInput(stack) != null;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return TileEntityCompost.getRecipeForInput(stack) == null;
    }
}

