/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityDisplayStand
extends TileEntityInventoryBase
implements IEnergyDisplay {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(80000, 1000, 0);
    private int oldEnergy;

    public TileEntityDisplayStand() {
        super(1, "displayStand");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            IDisplayStandItem item;
            if (StackUtil.isValid(this.slots.getStackInSlot(0)) && !this.isRedstonePowered && (item = this.convertToDisplayStandItem(this.slots.getStackInSlot(0).func_77973_b())) != null) {
                int energy = item.getUsePerTick(this.slots.getStackInSlot(0), this, this.ticksElapsed);
                if (this.storage.getEnergyStored() >= energy && item.update(this.slots.getStackInSlot(0), this, this.ticksElapsed)) {
                    this.storage.extractEnergyInternal(energy, false);
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    private IDisplayStandItem convertToDisplayStandItem(Item item) {
        Block block;
        if (item instanceof IDisplayStandItem) {
            return (IDisplayStandItem)item;
        }
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof IDisplayStandItem) {
            return (IDisplayStandItem)block;
        }
        return null;
    }

    @Override
    public boolean canExtractItem(int index, ItemStack stack) {
        return true;
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int getMaxStackSizePerSlot(int slot) {
        return 1;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

