/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEntityEmpowerer
extends TileEntityInventoryBase {
    public int processTime;
    public int recipeForRenderIndex = -1;
    private int lastRecipe;

    public TileEntityEmpowerer() {
        super(1, "empowerer");
    }

    public static List<EmpowererRecipe> getRecipesForInput(ItemStack input) {
        ArrayList<EmpowererRecipe> recipesThatWork = new ArrayList<EmpowererRecipe>();
        if (StackUtil.isValid(input)) {
            for (EmpowererRecipe recipe : ActuallyAdditionsAPI.EMPOWERER_RECIPES) {
                if (!StackUtil.isValid(recipe.input) || !recipe.input.func_77969_a(input)) continue;
                recipesThatWork.add(recipe);
            }
        }
        return recipesThatWork;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            List<EmpowererRecipe> recipes = TileEntityEmpowerer.getRecipesForInput(this.slots.getStackInSlot(0));
            if (!recipes.isEmpty()) {
                for (EmpowererRecipe recipe : recipes) {
                    TileEntityDisplayStand[] modifierStands = this.getFittingModifiers(recipe, recipe.time);
                    if (modifierStands == null) continue;
                    this.recipeForRenderIndex = ActuallyAdditionsAPI.EMPOWERER_RECIPES.indexOf(recipe);
                    ++this.processTime;
                    boolean done = this.processTime >= recipe.time;
                    for (TileEntityDisplayStand stand : modifierStands) {
                        stand.storage.extractEnergyInternal(recipe.energyPerStand / recipe.time, false);
                        if (!done) continue;
                        stand.slots.decrStackSize(0, 1);
                    }
                    if (this.processTime % 5 == 0 && this.field_145850_b instanceof WorldServer) {
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.FIREWORKS_SPARK, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.1, new int[0]);
                    }
                    if (done) {
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.END_ROD, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 100, 0.0, 0.0, 0.0, 0.25, new int[0]);
                        this.slots.setStackInSlot(0, recipe.output.func_77946_l());
                        this.func_70296_d();
                        this.processTime = 0;
                        this.recipeForRenderIndex = -1;
                    }
                    break;
                }
            } else {
                this.processTime = 0;
                this.recipeForRenderIndex = -1;
            }
            if (this.lastRecipe != this.recipeForRenderIndex) {
                this.lastRecipe = this.recipeForRenderIndex;
                this.sendUpdate();
            }
        }
    }

    private TileEntityDisplayStand[] getFittingModifiers(EmpowererRecipe recipe, int powerDivider) {
        TileEntityDisplayStand[] modifierStands = new TileEntityDisplayStand[4];
        ArrayList<ItemStack> itemsStillNeeded = new ArrayList<ItemStack>(Arrays.asList(recipe.modifier1, recipe.modifier2, recipe.modifier3, recipe.modifier4));
        for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
            int containPlace;
            TileEntityDisplayStand stand;
            EnumFacing facing = EnumFacing.field_176754_o[i];
            BlockPos offset = this.field_174879_c.func_177967_a(facing, 3);
            TileEntity tile = this.field_145850_b.func_175625_s(offset);
            if (tile instanceof TileEntityDisplayStand) {
                stand = (TileEntityDisplayStand)tile;
                ItemStack standItem = stand.slots.getStackInSlot(0);
                containPlace = ItemUtil.getPlaceAt(itemsStillNeeded, standItem, true);
                if (stand.storage.getEnergyStored() < recipe.energyPerStand / powerDivider || containPlace == -1) {
                    return null;
                }
            } else {
                return null;
            }
            modifierStands[i] = stand;
            itemsStillNeeded.remove(containPlace);
        }
        return modifierStands;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.func_74768_a("ProcessTime", this.processTime);
        }
        if (type == TileEntityBase.NBTType.SYNC) {
            compound.func_74768_a("RenderIndex", this.recipeForRenderIndex);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.processTime = compound.func_74762_e("ProcessTime");
        }
        if (type == TileEntityBase.NBTType.SYNC) {
            this.recipeForRenderIndex = compound.func_74762_e("RenderIndex");
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return !TileEntityEmpowerer.getRecipesForInput(stack).isEmpty();
    }

    @Override
    public boolean canExtractItem(int index, ItemStack stack) {
        return TileEntityEmpowerer.getRecipesForInput(stack).isEmpty();
    }

    @Override
    public int getMaxStackSizePerSlot(int slot) {
        return 1;
    }
}

