/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidCollector
extends TileEntityBase
implements ISharingFluidHandler {
    public boolean isPlacer;
    public final FluidTank tank = new FluidTank(8000){

        public boolean canFill() {
            return TileEntityFluidCollector.this.isPlacer;
        }

        public boolean canDrain() {
            return !TileEntityFluidCollector.this.isPlacer;
        }
    };
    private int lastTankAmount;
    private int currentTime;
    private int lastCompare;

    public TileEntityFluidCollector(String name) {
        super(name);
    }

    public TileEntityFluidCollector() {
        this("fluidCollector");
        this.isPlacer = false;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    private void doWork() {
        FluidStack stack;
        Block fluid;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        EnumFacing sideToManipulate = WorldUtil.getDirectionByPistonRotation(block.func_176201_c(state));
        BlockPos coordsBlock = this.field_174879_c.func_177972_a(sideToManipulate);
        IBlockState stateToBreak = this.field_145850_b.func_180495_p(coordsBlock);
        Block blockToBreak = stateToBreak.func_177230_c();
        if (!this.isPlacer && blockToBreak != null && blockToBreak.func_176201_c(stateToBreak) == 0 && 1000 <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
            if (blockToBreak instanceof IFluidBlock && ((IFluidBlock)blockToBreak).getFluid() != null) {
                if (this.tank.fillInternal(new FluidStack(((IFluidBlock)blockToBreak).getFluid(), 1000), false) >= 1000) {
                    this.tank.fillInternal(new FluidStack(((IFluidBlock)blockToBreak).getFluid(), 1000), true);
                    this.field_145850_b.func_175698_g(coordsBlock);
                }
            } else if (blockToBreak == Blocks.field_150353_l || blockToBreak == Blocks.field_150356_k) {
                if (this.tank.fillInternal(new FluidStack(FluidRegistry.LAVA, 1000), false) >= 1000) {
                    this.tank.fillInternal(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    this.field_145850_b.func_175698_g(coordsBlock);
                }
            } else if ((blockToBreak == Blocks.field_150355_j || blockToBreak == Blocks.field_150358_i) && this.tank.fillInternal(new FluidStack(FluidRegistry.WATER, 1000), false) >= 1000) {
                this.tank.fillInternal(new FluidStack(FluidRegistry.WATER, 1000), true);
                this.field_145850_b.func_175698_g(coordsBlock);
            }
        } else if (this.isPlacer && blockToBreak.func_176200_f((IBlockAccess)this.field_145850_b, coordsBlock) && this.tank.getFluidAmount() >= 1000 && (fluid = (stack = this.tank.getFluid()).getFluid().getBlock()) != null) {
            boolean placeable;
            BlockPos offsetPos = this.field_174879_c.func_177972_a(sideToManipulate);
            boolean bl = placeable = !(blockToBreak instanceof BlockLiquid) && !(blockToBreak instanceof IFluidBlock) && blockToBreak.func_176200_f((IBlockAccess)this.field_145850_b, offsetPos);
            if (placeable) {
                this.tank.drainInternal(1000, true);
                if (this.field_145850_b.field_73011_w.func_177500_n() && stack.getFluid().doesVaporize(stack)) {
                    this.field_145850_b.func_184133_a(null, offsetPos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                    if (this.field_145850_b instanceof WorldServer) {
                        for (int l = 0; l < 8; ++l) {
                            ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.SMOKE_LARGE, false, (double)offsetPos.func_177958_n() + Math.random(), (double)offsetPos.func_177956_o() + Math.random(), (double)offsetPos.func_177952_p() + Math.random(), 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                } else {
                    this.field_145850_b.func_180501_a(offsetPos, fluid.func_176223_P(), 3);
                }
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 15.0f;
        return (int)calc;
    }

    @Override
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.tank;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
        this.tank.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
        this.tank.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.isPulseMode) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 15;
                }
            }
            if (this.lastCompare != this.getComparatorStrength()) {
                this.lastCompare = this.getComparatorStrength();
                this.func_70296_d();
            }
            if (this.lastTankAmount != this.tank.getFluidAmount() && this.sendUpdateWithInterval()) {
                this.lastTankAmount = this.tank.getFluidAmount();
            }
        }
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return this.tank.getFluidAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return !this.isPlacer;
    }

    @Override
    public EnumFacing[] getFluidShareSides() {
        return EnumFacing.values();
    }
}

