/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.CommonCapsUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;

public class TileEntityItemViewer
extends TileEntityBase {
    public final List<GenericItemHandlerInfo> genericInfos = new ArrayList<GenericItemHandlerInfo>();
    public final Map<Integer, IItemHandlerInfo> itemHandlerInfos = new HashMap<Integer, IItemHandlerInfo>();
    public final List<SlotlessItemHandlerInfo> slotlessInfos = new ArrayList<SlotlessItemHandlerInfo>();
    protected final SlotlessableItemHandlerWrapper itemHandler;
    public TileEntityLaserRelayItem connectedRelay;
    private int lastNetworkChangeAmount = -1;

    public TileEntityItemViewer(String name) {
        super(name);
        IItemHandler normalHandler = new IItemHandler(){

            public int getSlots() {
                int size = 0;
                List infos = TileEntityItemViewer.this.getItemHandlerInfos();
                if (infos != null) {
                    for (GenericItemHandlerInfo info : infos) {
                        if (!info.isLoaded()) continue;
                        for (SlotlessableItemHandlerWrapper handler : info.handlers) {
                            IItemHandler normalHandler = handler.getNormalHandler();
                            if (normalHandler == null) continue;
                            size += normalHandler.getSlots();
                        }
                    }
                }
                return size;
            }

            public ItemStack getStackInSlot(int slot) {
                IItemHandlerInfo handler = TileEntityItemViewer.this.getSwitchedIndexHandler(slot);
                if (handler != null && handler.isLoaded()) {
                    return handler.handler.getStackInSlot(handler.switchedIndex);
                }
                return StackUtil.getNull();
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                IItemHandlerInfo info = TileEntityItemViewer.this.getSwitchedIndexHandler(slot);
                if (info != null && info.isLoaded() && TileEntityItemViewer.this.isWhitelisted(info, stack, false)) {
                    ItemStack remain = info.handler.insertItem(info.switchedIndex, stack, simulate);
                    if (!ItemStack.func_77989_b((ItemStack)remain, (ItemStack)stack) && !simulate) {
                        TileEntityItemViewer.this.func_70296_d();
                        TileEntityItemViewer.this.doItemParticle(stack, info.relayInQuestion.func_174877_v(), TileEntityItemViewer.this.connectedRelay.func_174877_v());
                    }
                    return remain;
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                IItemHandlerInfo info;
                ItemStack stackIn = this.getStackInSlot(slot);
                if (StackUtil.isValid(stackIn) && (info = TileEntityItemViewer.this.getSwitchedIndexHandler(slot)) != null && info.isLoaded() && TileEntityItemViewer.this.isWhitelisted(info, stackIn, true)) {
                    ItemStack extracted = info.handler.extractItem(info.switchedIndex, amount, simulate);
                    if (StackUtil.isValid(extracted) && !simulate) {
                        TileEntityItemViewer.this.func_70296_d();
                        TileEntityItemViewer.this.doItemParticle(extracted, TileEntityItemViewer.this.connectedRelay.func_174877_v(), info.relayInQuestion.func_174877_v());
                    }
                    return extracted;
                }
                return StackUtil.getNull();
            }

            public int getSlotLimit(int slot) {
                IItemHandlerInfo info = TileEntityItemViewer.this.getSwitchedIndexHandler(slot);
                if (info != null && info.isLoaded()) {
                    return info.handler.getSlotLimit(info.switchedIndex);
                }
                return 0;
            }
        };
        ISlotlessItemHandler slotlessHandler = null;
        if (ActuallyAdditions.commonCapsLoaded) {
            slotlessHandler = CommonCapsUtil.createSlotlessItemViewerHandler(this, normalHandler);
        }
        this.itemHandler = new SlotlessableItemHandlerWrapper(normalHandler, slotlessHandler);
    }

    public TileEntityItemViewer() {
        this("itemViewer");
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.itemHandler.getNormalHandler();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object handler;
        if (ActuallyAdditions.commonCapsLoaded && capability == SlotlessItemHandlerConfig.CAPABILITY && (handler = this.itemHandler.getSlotlessHandler()) != null) {
            return (T)handler;
        }
        return super.getCapability(capability, facing);
    }

    private List<GenericItemHandlerInfo> getItemHandlerInfos() {
        this.queryAndSaveData();
        return this.genericInfos;
    }

    public void doItemParticle(ItemStack stack, BlockPos input, BlockPos output) {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound compound = new NBTTagCompound();
            stack.func_77955_b(compound);
            compound.func_74780_a("InX", (double)input.func_177958_n());
            compound.func_74780_a("InY", (double)input.func_177956_o());
            compound.func_74780_a("InZ", (double)input.func_177952_p());
            compound.func_74780_a("OutX", (double)output.func_177958_n());
            compound.func_74780_a("OutY", (double)output.func_177956_o());
            compound.func_74780_a("OutZ", (double)output.func_177952_p());
            int rangeSq = 256;
            for (EntityPlayer player : this.field_145850_b.field_73010_i) {
                if (!(player instanceof EntityPlayerMP) || !(player.func_174818_b(input) <= (double)rangeSq) && !(player.func_174818_b(output) <= (double)rangeSq)) continue;
                PacketHandler.theNetwork.sendTo((IMessage)new PacketServerToClient(compound, PacketHandler.LASER_PARTICLE_HANDLER), (EntityPlayerMP)player);
            }
        }
    }

    private void queryAndSaveData() {
        Network network;
        if (this.connectedRelay != null && (network = this.connectedRelay.getNetwork()) != null) {
            if (this.lastNetworkChangeAmount != network.changeAmount) {
                this.clearInfos();
                this.connectedRelay.getItemHandlersInNetwork(network, this.genericInfos);
                if (!this.genericInfos.isEmpty()) {
                    Collections.sort(this.genericInfos);
                    int slotsQueried = 0;
                    for (GenericItemHandlerInfo info : this.genericInfos) {
                        for (SlotlessableItemHandlerWrapper handler : info.handlers) {
                            Object slotlessHandler;
                            IItemHandler normalHandler = handler.getNormalHandler();
                            if (normalHandler != null) {
                                for (int i = 0; i < normalHandler.getSlots(); ++i) {
                                    this.itemHandlerInfos.put(slotsQueried, new IItemHandlerInfo(normalHandler, i, info.relayInQuestion));
                                    ++slotsQueried;
                                }
                            }
                            if (!ActuallyAdditions.commonCapsLoaded || !((slotlessHandler = handler.getSlotlessHandler()) instanceof ISlotlessItemHandler)) continue;
                            this.slotlessInfos.add(new SlotlessItemHandlerInfo(slotlessHandler, info.relayInQuestion));
                        }
                    }
                }
                this.lastNetworkChangeAmount = network.changeAmount;
            }
            return;
        }
        this.clearInfos();
        this.lastNetworkChangeAmount = -1;
    }

    private void clearInfos() {
        if (!this.genericInfos.isEmpty()) {
            this.genericInfos.clear();
        }
        if (!this.itemHandlerInfos.isEmpty()) {
            this.itemHandlerInfos.clear();
        }
        if (!this.slotlessInfos.isEmpty()) {
            this.slotlessInfos.clear();
        }
    }

    private IItemHandlerInfo getSwitchedIndexHandler(int i) {
        this.queryAndSaveData();
        return this.itemHandlerInfos.get(i);
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        TileEntityLaserRelayItem tileFound = null;
        if (this.field_145850_b != null) {
            for (int i = 0; i <= 5; ++i) {
                TileEntity tile;
                EnumFacing side = WorldUtil.getDirectionBySidesInOrder(i);
                BlockPos pos = this.func_174877_v().func_177972_a(side);
                if (!this.field_145850_b.func_175667_e(pos) || !((tile = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityLaserRelayItem)) continue;
                if (tileFound != null) {
                    this.connectedRelay = null;
                    return;
                }
                tileFound = (TileEntityLaserRelayItem)tile;
            }
        }
        this.connectedRelay = tileFound;
    }

    public boolean isWhitelisted(SpecificItemHandlerInfo handler, ItemStack stack, boolean output) {
        boolean whitelisted = handler.relayInQuestion.isWhitelisted(stack, output);
        TileEntityLaserRelayItem connected = this.connectedRelay;
        if (connected != null && connected != handler.relayInQuestion) {
            return whitelisted && connected.isWhitelisted(stack, output);
        }
        return whitelisted;
    }

    public static class GenericItemHandlerInfo
    implements Comparable<GenericItemHandlerInfo> {
        public final List<SlotlessableItemHandlerWrapper> handlers = new ArrayList<SlotlessableItemHandlerWrapper>();
        public final TileEntityLaserRelayItem relayInQuestion;

        public GenericItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.func_145830_o() && this.relayInQuestion.func_145831_w().func_175667_e(this.relayInQuestion.func_174877_v());
        }

        @Override
        public int compareTo(GenericItemHandlerInfo other) {
            int otherPrio;
            int thisPrio = this.relayInQuestion.getPriority();
            if (thisPrio == (otherPrio = other.relayInQuestion.getPriority())) {
                return 0;
            }
            if (thisPrio > otherPrio) {
                return -1;
            }
            return 1;
        }
    }

    private static class SpecificItemHandlerInfo {
        public final TileEntityLaserRelayItem relayInQuestion;

        public SpecificItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.func_145830_o() && this.relayInQuestion.func_145831_w().func_175667_e(this.relayInQuestion.func_174877_v());
        }
    }

    private static class IItemHandlerInfo
    extends SpecificItemHandlerInfo {
        public final IItemHandler handler;
        public final int switchedIndex;

        public IItemHandlerInfo(IItemHandler handler, int switchedIndex, TileEntityLaserRelayItem relayInQuestion) {
            super(relayInQuestion);
            this.handler = handler;
            this.switchedIndex = switchedIndex;
        }
    }

    public static class SlotlessItemHandlerInfo
    extends SpecificItemHandlerInfo {
        public final Object handler;

        public SlotlessItemHandlerInfo(Object handler, TileEntityLaserRelayItem relayInQuestion) {
            super(relayInQuestion);
            this.handler = handler;
        }
    }
}

