/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPhantomPlacer
extends TileEntityInventoryBase
implements IPhantomTile,
IButtonReactor {
    public static final int RANGE = 3;
    public BlockPos boundPosition;
    public int currentTime;
    public int range;
    public boolean isBreaker;
    public int side;
    private int oldRange;

    public TileEntityPhantomPlacer(int slots, String name) {
        super(slots, name);
    }

    public TileEntityPhantomPlacer() {
        super(9, "phantomPlacer");
        this.isBreaker = false;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Range", this.range);
            if (this.boundPosition != null) {
                compound.func_74768_a("xOfTileStored", this.boundPosition.func_177958_n());
                compound.func_74768_a("yOfTileStored", this.boundPosition.func_177956_o());
                compound.func_74768_a("zOfTileStored", this.boundPosition.func_177952_p());
            }
            if (!this.isBreaker) {
                compound.func_74768_a("Side", this.side);
            }
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            int x = compound.func_74762_e("xOfTileStored");
            int y = compound.func_74762_e("yOfTileStored");
            int z = compound.func_74762_e("zOfTileStored");
            this.range = compound.func_74762_e("Range");
            if (x != 0 || y != 0 || z != 0) {
                this.boundPosition = new BlockPos(x, y, z);
                this.func_70296_d();
            }
            if (!this.isBreaker) {
                this.side = compound.func_74762_e("Side");
            }
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            this.range = TileEntityPhantomface.upgradeRange(3, this.field_145850_b, this.field_174879_c);
            if (!this.hasBoundPosition()) {
                this.boundPosition = null;
            }
            if (this.isBoundThingInRange() && !this.isRedstonePowered && !this.isPulseMode) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 30;
                }
            }
            if (this.oldRange != this.range) {
                this.oldRange = this.range;
                this.sendUpdate();
            }
        } else if (this.boundPosition != null) {
            this.renderParticles();
        }
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.field_145850_b.func_175625_s(this.boundPosition) instanceof IPhantomTile || this.func_174877_v().func_177958_n() == this.boundPosition.func_177958_n() && this.func_174877_v().func_177956_o() == this.boundPosition.func_177956_o() && this.func_174877_v().func_177952_p() == this.boundPosition.func_177952_p() && this.field_145850_b.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension()) {
                this.boundPosition = null;
                return false;
            }
            return this.field_145850_b.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension();
        }
        return false;
    }

    private void doWork() {
        if (this.isBoundThingInRange()) {
            if (this.isBreaker) {
                Block blockToBreak = this.field_145850_b.func_180495_p(this.boundPosition).func_177230_c();
                if (blockToBreak != null && this.field_145850_b.func_180495_p(this.boundPosition).func_185887_b(this.field_145850_b, this.boundPosition) > -1.0f) {
                    NonNullList drops = NonNullList.func_191196_a();
                    blockToBreak.getDrops(drops, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.boundPosition), 0);
                    if (WorldUtil.addToInventory(this.slots, (List<ItemStack>)drops, false)) {
                        this.field_145850_b.func_175718_b(2001, this.boundPosition, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(this.boundPosition)));
                        this.field_145850_b.func_175698_g(this.boundPosition);
                        WorldUtil.addToInventory(this.slots, (List<ItemStack>)drops, true);
                        this.func_70296_d();
                    }
                }
            } else {
                int theSlot = WorldUtil.findFirstFilledSlot(this.slots);
                this.slots.setStackInSlot(theSlot, WorldUtil.useItemAtSide(WorldUtil.getDirectionBySidesInOrder(this.side), this.field_145850_b, this.boundPosition, this.slots.getStackInSlot(theSlot)));
                if (!StackUtil.isValid(this.slots.getStackInSlot(theSlot))) {
                    this.slots.setStackInSlot(theSlot, StackUtil.getNull());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            double d1 = (float)this.boundPosition.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            int i1 = this.field_145850_b.field_73012_v.nextInt(2) * 2 - 1;
            int j1 = this.field_145850_b.field_73012_v.nextInt(2) * 2 - 1;
            double d4 = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.func_177952_p() + 0.5 + 0.25 * (double)j1;
            double d5 = this.field_145850_b.field_73012_v.nextFloat() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.func_177958_n() + 0.5 + 0.25 * (double)i1;
            double d3 = this.field_145850_b.field_73012_v.nextFloat() * 1.0f * (float)i1;
            this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.func_177951_i((Vec3i)this.field_174879_c) <= (double)(this.range * this.range);
    }

    @Override
    public BlockPos getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(BlockPos pos) {
        this.boundPosition = pos;
    }

    @Override
    public int getGuiID() {
        return GuiHandler.GuiTypes.PHANTOM_PLACER.ordinal();
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return !this.isBreaker;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return this.isBreaker;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        this.side = this.side + 1 >= EnumFacing.values().length ? 0 : ++this.side;
        this.sendUpdate();
    }
}

