/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.UUID;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class TileEntityPlayerInterface
extends TileEntityBase
implements IEnergyDisplay {
    public static final int DEFAULT_RANGE = 32;
    private final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 50, 0);
    public UUID connectedPlayer;
    public String playerName;
    private IItemHandler playerHandler;
    private EntityPlayer oldPlayer;
    private int oldEnergy;
    private int range;

    public TileEntityPlayerInterface() {
        super("playerInterface");
    }

    private EntityPlayer getPlayer() {
        EntityPlayer player;
        if (this.connectedPlayer != null && (player = this.field_145850_b.func_152378_a(this.connectedPlayer)) != null && player.func_70011_f((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) <= (double)this.range) {
            return player;
        }
        return null;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        EntityPlayer player = this.getPlayer();
        if (this.oldPlayer != player) {
            this.oldPlayer = player;
            this.playerHandler = player == null ? null : new PlayerInvWrapper(player.field_71071_by);
        }
        return this.playerHandler;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean changed = false;
            this.range = TileEntityPhantomface.upgradeRange(32, this.field_145850_b, this.field_174879_c);
            EntityPlayer player = this.getPlayer();
            if (player != null) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_() && this.storage.getEnergyStored() > 0; ++i) {
                    IEnergyStorage cap;
                    ItemStack slot = player.field_71071_by.func_70301_a(i);
                    if (!StackUtil.isValid(slot)) continue;
                    int received = 0;
                    if (slot.hasCapability(CapabilityEnergy.ENERGY, null)) {
                        cap = (IEnergyStorage)slot.getCapability(CapabilityEnergy.ENERGY, null);
                        if (cap != null) {
                            received = cap.receiveEnergy(this.storage.getEnergyStored(), false);
                        }
                    } else if (ActuallyAdditions.teslaLoaded && slot.hasCapability(TeslaUtil.teslaConsumer, null) && (cap = (ITeslaConsumer)slot.getCapability(TeslaUtil.teslaConsumer, null)) != null) {
                        received = (int)cap.givePower((long)this.storage.getEnergyStored(), false);
                    }
                    if (received <= 0) continue;
                    this.storage.extractEnergyInternal(received, false);
                }
            }
            if (changed) {
                this.func_70296_d();
                this.sendUpdate();
            }
            if (this.storage.getEnergyStored() != this.oldEnergy && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (this.connectedPlayer != null && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_186854_a("Player", this.connectedPlayer);
            compound.func_74778_a("PlayerName", this.playerName);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (compound.func_74764_b("PlayerLeast") && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.connectedPlayer = compound.func_186857_a("Player");
            this.playerName = compound.func_74779_i("PlayerName");
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

