/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util.compat;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.DefaultSlotlessItemHandlerWrapper;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;

public final class CommonCapsUtil {
    public static ISlotlessItemHandler createSlotlessItemViewerHandler(final TileEntityItemViewer tile, IItemHandler normalHandler) {
        return new DefaultSlotlessItemHandlerWrapper(normalHandler){

            public ItemStack insertItem(ItemStack stack, boolean simulate) {
                ItemStack remain = StackUtil.validateCopy(stack);
                for (TileEntityItemViewer.SlotlessItemHandlerInfo handler : tile.slotlessInfos) {
                    if (!handler.isLoaded() || !tile.isWhitelisted(handler, stack, false) || !(handler.handler instanceof ISlotlessItemHandler)) continue;
                    remain = ((ISlotlessItemHandler)handler.handler).insertItem(stack, simulate);
                    if (!ItemStack.func_77989_b((ItemStack)remain, (ItemStack)stack) && !simulate) {
                        tile.func_70296_d();
                        tile.doItemParticle(stack, handler.relayInQuestion.func_174877_v(), tile.connectedRelay.func_174877_v());
                    }
                    if (StackUtil.isValid(remain)) continue;
                    return StackUtil.getNull();
                }
                return super.insertItem(remain, simulate);
            }

            public ItemStack extractItem(int amount, boolean simulate) {
                for (TileEntityItemViewer.SlotlessItemHandlerInfo handler : tile.slotlessInfos) {
                    ISlotlessItemHandler slotless;
                    ItemStack would;
                    if (!handler.isLoaded() || !(handler.handler instanceof ISlotlessItemHandler) || !StackUtil.isValid(would = (slotless = (ISlotlessItemHandler)handler.handler).extractItem(amount, true)) || !tile.isWhitelisted(handler, would, true)) continue;
                    ItemStack has = simulate ? would : slotless.extractItem(amount, false);
                    if (StackUtil.isValid(has) && !simulate) {
                        tile.func_70296_d();
                        tile.doItemParticle(has, tile.connectedRelay.func_174877_v(), handler.relayInQuestion.func_174877_v());
                    }
                    return has;
                }
                return super.extractItem(amount, simulate);
            }

            public ItemStack extractItem(ItemStack matchStack, int matchFlags, boolean simulate) {
                for (TileEntityItemViewer.SlotlessItemHandlerInfo handler : tile.slotlessInfos) {
                    ISlotlessItemHandler slotless;
                    ItemStack would;
                    if (!handler.isLoaded() || !(handler.handler instanceof ISlotlessItemHandler) || !StackUtil.isValid(would = (slotless = (ISlotlessItemHandler)handler.handler).extractItem(matchStack, matchFlags, true)) || !tile.isWhitelisted(handler, would, true)) continue;
                    if (simulate) {
                        return would;
                    }
                    return slotless.extractItem(matchStack, matchFlags, false);
                }
                return super.extractItem(matchStack, matchFlags, simulate);
            }
        };
    }
}

