/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires.redstone;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.common.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class RedstoneWireNetwork {
    public byte[] channelValues = new byte[16];
    public List<WeakReference<IRedstoneConnector>> connectors = new ArrayList<WeakReference<IRedstoneConnector>>();

    public RedstoneWireNetwork add(IRedstoneConnector connector) {
        this.connectors.add(new WeakReference<IRedstoneConnector>(connector));
        return this;
    }

    public void mergeNetwork(RedstoneWireNetwork wireNetwork) {
        IRedstoneConnector connector;
        for (WeakReference<IRedstoneConnector> connectorRef : wireNetwork.connectors) {
            connector = (IRedstoneConnector)connectorRef.get();
            if (connector == null) continue;
            connector.setNetwork(this.add(connector));
        }
        for (WeakReference<IRedstoneConnector> connectorRef : wireNetwork.connectors) {
            connector = (IRedstoneConnector)connectorRef.get();
            if (connector == null) continue;
            connector.onChange();
        }
        this.updateValues();
    }

    public void removeFromNetwork(IRedstoneConnector removedConnector) {
        IRedstoneConnector connector;
        BlockPos removedCC = Utils.toCC(removedConnector);
        for (WeakReference<IRedstoneConnector> connectorRef : this.connectors) {
            connector = (IRedstoneConnector)connectorRef.get();
            if (connector == null) continue;
            connector.setNetwork(new RedstoneWireNetwork().add(connector));
        }
        for (WeakReference<IRedstoneConnector> connectorRef : this.connectors) {
            connector = (IRedstoneConnector)connectorRef.get();
            if (connector == null) continue;
            BlockPos conCC = Utils.toCC(connector);
            Set<ImmersiveNetHandler.Connection> connections = ImmersiveNetHandler.INSTANCE.getConnections(connector.getConnectorWorld(), conCC);
            if (connections != null) {
                for (ImmersiveNetHandler.Connection connection : connections) {
                    TileEntity nodeTile;
                    BlockPos node = connection.start;
                    if (node.equals((Object)conCC)) {
                        node = connection.end;
                    }
                    if (node.equals((Object)removedCC) || !((nodeTile = Utils.getExistingTileEntity(connector.getConnectorWorld(), node)) instanceof IRedstoneConnector) || connector.getNetwork() == ((IRedstoneConnector)nodeTile).getNetwork()) continue;
                    connector.getNetwork().mergeNetwork(((IRedstoneConnector)nodeTile).getNetwork());
                }
            }
            connector.onChange();
        }
    }

    public void updateValues() {
        IRedstoneConnector connector;
        byte[] oldValues = this.channelValues;
        this.channelValues = new byte[16];
        for (WeakReference<IRedstoneConnector> connectorRef : this.connectors) {
            connector = (IRedstoneConnector)connectorRef.get();
            if (connector == null) continue;
            connector.updateInput(this.channelValues);
        }
        if (!Arrays.equals(oldValues, this.channelValues)) {
            for (WeakReference<IRedstoneConnector> connectorRef : this.connectors) {
                connector = (IRedstoneConnector)connectorRef.get();
                if (connector == null) continue;
                connector.onChange();
            }
        }
    }

    public int getPowerOutput(int redstoneChannel) {
        return this.channelValues[redstoneChannel];
    }

    public byte[] getByteValues() {
        byte[] values = new byte[16];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (byte)(this.channelValues[i] * 16);
        }
        return values;
    }
}

