/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.lwjgl.util.vector.Vector3f;

public class ModelConfigurableSides
implements IBakedModel {
    private static final String MODEL_PREFIX = "conf_sides_";
    private static final String RESOURCE_LOCATION = "models/block/smartmodel/conf_sides_";
    private static HashMap<String, ITextureNamer> TYPES = new HashMap();
    public static HashMap<String, List<BakedQuad>> modelCache;
    final String name;
    public TextureAtlasSprite[][] textures;
    static final ItemCameraTransforms defaultTransforms;

    public ModelConfigurableSides(String name, TextureAtlasSprite[][] textures) {
        this.name = name;
        this.textures = textures;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        String key;
        TextureAtlasSprite[] tex = new TextureAtlasSprite[6];
        for (int i = 0; i < tex.length; ++i) {
            tex[i] = this.textures[i][0];
        }
        char[] keyArray = "000000".toCharArray();
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extended = (IExtendedBlockState)state;
            for (int i = 0; i < IEProperties.SIDECONFIG.length; ++i) {
                IEEnums.SideConfig config;
                if (!extended.getUnlistedNames().contains(IEProperties.SIDECONFIG[i]) || (config = (IEEnums.SideConfig)((Object)extended.getValue((IUnlistedProperty)IEProperties.SIDECONFIG[i]))) == null) continue;
                int c = config.ordinal();
                tex[i] = this.textures[i][c];
                keyArray[i] = Character.forDigit(c, 10);
            }
        }
        if (!modelCache.containsKey(key = this.name + String.copyValueOf(keyArray))) {
            modelCache.put(key, ModelConfigurableSides.bakeQuads(tex));
        }
        return modelCache.get(key);
    }

    private static List<BakedQuad> bakeQuads(TextureAtlasSprite[] sprites) {
        ArrayList quads = Lists.newArrayListWithExpectedSize((int)6);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.DOWN, sprites[0], new double[]{0.0, 16.0, 16.0, 0.0}, colour, true));
        vertices = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.UP, sprites[1], new double[]{0.0, 0.0, 16.0, 16.0}, colour, false));
        vertices = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.NORTH, sprites[2], new double[]{0.0, 16.0, 16.0, 0.0}, colour, true));
        vertices = new Vector3f[]{new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.SOUTH, sprites[3], new double[]{16.0, 16.0, 0.0, 0.0}, colour, false));
        vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.WEST, sprites[4], new double[]{0.0, 16.0, 16.0, 0.0}, colour, true));
        vertices = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f)};
        quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.EAST, sprites[5], new double[]{16.0, 16.0, 0.0, 0.0}, colour, false));
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.textures[0][0];
    }

    public ItemCameraTransforms func_177552_f() {
        return defaultTransforms;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static {
        TYPES.put("all6_", new ITextureNamer(){});
        TYPES.put("s_", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, IEEnums.SideConfig cfg) {
                return "side";
            }
        });
        TYPES.put("hud_", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, IEEnums.SideConfig cfg) {
                return side.ordinal() < 2 ? side.func_176610_l() : "side";
            }
        });
        TYPES.put("hv_", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, IEEnums.SideConfig cfg) {
                return side.ordinal() < 2 ? "up" : "side";
            }
        });
        TYPES.put("ud_", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, IEEnums.SideConfig cfg) {
                return side.ordinal() < 2 ? side.func_176610_l() : "side";
            }

            @Override
            public String nameFromCfg(EnumFacing side, IEEnums.SideConfig cfg) {
                return side.ordinal() < 2 ? cfg.getTextureName() : null;
            }
        });
        TYPES.put("v_", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, IEEnums.SideConfig cfg) {
                return side.ordinal() < 2 ? "up" : "side";
            }

            @Override
            public String nameFromCfg(EnumFacing side, IEEnums.SideConfig cfg) {
                return side.ordinal() < 2 ? cfg.getTextureName() : null;
            }
        });
        modelCache = new HashMap();
        defaultTransforms = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.25f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
    }

    static interface ITextureNamer {
        default public String getTextureName(EnumFacing side, IEEnums.SideConfig cfg) {
            String s = this.nameFromSide(side, cfg);
            String c = this.nameFromCfg(side, cfg);
            if (s != null && c != null) {
                return s + "_" + c;
            }
            if (s != null) {
                return s;
            }
            if (c != null) {
                return c;
            }
            return "";
        }

        default public String nameFromSide(EnumFacing side, IEEnums.SideConfig cfg) {
            return side.func_176610_l();
        }

        default public String nameFromCfg(EnumFacing side, IEEnums.SideConfig cfg) {
            return cfg.getTextureName();
        }
    }

    private static class ConfigSidesModelBase
    implements IModel {
        final String name;
        final String type;
        ImmutableMap<String, ResourceLocation> textures;

        public ConfigSidesModelBase(String name, String type, ImmutableMap<String, ResourceLocation> textures) {
            this.name = name;
            this.type = type;
            this.textures = textures;
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of();
        }

        public Collection<ResourceLocation> getTextures() {
            return this.textures.values();
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            TextureAtlasSprite[][] tex = new TextureAtlasSprite[6][3];
            for (EnumFacing f : EnumFacing.field_82609_l) {
                for (IEEnums.SideConfig cfg : IEEnums.SideConfig.values()) {
                    ResourceLocation rl = (ResourceLocation)this.textures.get((Object)(f.func_176610_l() + "_" + cfg.getTextureName()));
                    if (rl == null) continue;
                    tex[f.ordinal()][cfg.ordinal()] = ApiUtils.getRegisterSprite(ClientUtils.mc().func_147117_R(), rl);
                }
            }
            return new ModelConfigurableSides(this.name, tex);
        }

        public IModelState getDefaultState() {
            return null;
        }

        public IModel retexture(ImmutableMap<String, String> textures) {
            String newName = this.name;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EnumFacing f : EnumFacing.field_82609_l) {
                for (IEEnums.SideConfig cfg : IEEnums.SideConfig.values()) {
                    ITextureNamer namer;
                    String key = f.func_176610_l() + "_" + cfg.getTextureName();
                    ResourceLocation rl = (ResourceLocation)this.textures.get((Object)key);
                    if (textures.containsKey((Object)key)) {
                        rl = new ResourceLocation((String)textures.get((Object)key));
                    } else if (textures.containsKey((Object)f.func_176610_l())) {
                        String c;
                        namer = (ITextureNamer)TYPES.get(this.type);
                        rl = new ResourceLocation((String)textures.get((Object)f.func_176610_l()));
                        if (namer != null && (c = namer.nameFromCfg(f, cfg)) != null) {
                            rl = new ResourceLocation((String)textures.get((Object)f.func_176610_l()) + "_" + c);
                        }
                    } else if (textures.containsKey((Object)"name")) {
                        namer = (ITextureNamer)TYPES.get(this.type);
                        newName = (String)textures.get((Object)"name");
                        if (namer != null) {
                            rl = new ResourceLocation(newName + "_" + namer.getTextureName(f, cfg));
                        }
                    }
                    builder.put((Object)key, (Object)rl);
                }
            }
            return new ConfigSidesModelBase(newName, this.type, (ImmutableMap<String, ResourceLocation>)builder.build());
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public void func_110549_a(IResourceManager resourceManager) {
            modelCache.clear();
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110623_a().contains(ModelConfigurableSides.RESOURCE_LOCATION);
        }

        public IModel loadModel(ResourceLocation modelLocation) throws IOException {
            String resourcePath = modelLocation.func_110623_a();
            int pos = resourcePath.indexOf(ModelConfigurableSides.MODEL_PREFIX);
            if (pos >= 0) {
                String sub;
                String name = sub = resourcePath.substring(pos += ModelConfigurableSides.MODEL_PREFIX.length());
                String type = null;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry e : TYPES.entrySet()) {
                    if (!sub.startsWith((String)e.getKey())) continue;
                    type = (String)e.getKey();
                    name = sub.substring(type.length());
                    for (EnumFacing f : EnumFacing.field_82609_l) {
                        for (IEEnums.SideConfig cfg : IEEnums.SideConfig.values()) {
                            String key = f.func_176610_l() + "_" + cfg.getTextureName();
                            String tex = name + "_" + ((ITextureNamer)e.getValue()).getTextureName(f, cfg);
                            builder.put((Object)key, (Object)new ResourceLocation("immersiveengineering", "blocks/" + tex));
                        }
                    }
                }
                return new ConfigSidesModelBase(name, type, (ImmutableMap<String, ResourceLocation>)builder.build());
            }
            return ModelLoaderRegistry.getMissingModel();
        }
    }
}

