/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityEnergyMeter
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride {
    public EnumFacing facing = EnumFacing.NORTH;
    public int lastEnergyPassed = 0;
    public ArrayList<Integer> lastPackets = new ArrayList(25);
    public boolean lower = true;
    private int compVal = -1;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return true;
    }

    @Override
    protected boolean isRelay() {
        return true;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntity above;
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IWireCoil) {
            return false;
        }
        int transfer = this.getAveragePower();
        int packets = this.lastPackets.size();
        if (this.lower && (above = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, 1, 0))) instanceof TileEntityEnergyMeter) {
            packets = ((TileEntityEnergyMeter)above).lastPackets.size();
        }
        String transferred = "0";
        if (transfer > 0) {
            transferred = Utils.formatDouble(transfer, "0.###");
        }
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.energyTransfered", new Object[]{packets, transferred})});
        return true;
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.lower || this.field_145850_b.field_72995_K) {
            return;
        }
        if ((this.field_145850_b.func_82737_E() & 0x1FL) == (this.field_174879_c.func_177986_g() & 0x1FL) || this.compVal < 0) {
            this.updateComparatorValues();
        }
        this.lastPackets.add(this.lastEnergyPassed);
        if (this.lastPackets.size() > 20) {
            this.lastPackets.remove(0);
        }
        this.lastEnergyPassed = 0;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
        this.lastEnergyPassed += amount;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (this.lower) {
            TileEntity above = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, 1, 0));
            if (above instanceof TileEntityEnergyMeter) {
                return ((TileEntityEnergyMeter)above).canConnectCable(cableType, target);
            }
            return false;
        }
        return super.canConnectCable(cableType, target);
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        if (this.lower) {
            TileEntity above = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, 1, 0));
            if (above instanceof TileEntityEnergyMeter) {
                ((TileEntityEnergyMeter)above).connectCable(cableType, target, other);
            }
        } else {
            super.connectCable(cableType, target, other);
        }
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        if (this.lower) {
            return this.field_174879_c.func_177984_a();
        }
        return this.field_174879_c;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("dummy", this.lower);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.values()[nbt.func_74762_e("facing")];
        this.lower = nbt.func_74767_n("dummy");
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = ((TileEntity)link).func_174877_v().func_177958_n() - this.func_174877_v().func_177958_n();
        int zDif = ((TileEntity)link).func_174877_v().func_177952_p() - this.func_174877_v().func_177952_p();
        if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
            return new Vec3d(0.5, 0.4375, zDif > 0 ? 0.8125 : 0.1875);
        }
        return new Vec3d(xDif > 0 ? 0.8125 : 0.1875, 0.4375, 0.5);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.func_177958_n() - this.func_174877_v().func_177958_n() : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.func_177958_n() - this.func_174877_v().func_177958_n() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.func_177952_p() - this.func_174877_v().func_177952_p() : (zDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.func_177952_p() - this.func_174877_v().func_177952_p() : 0));
        if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
            return new Vec3d(0.5, 0.4375, zDif > 0 ? 0.8125 : 0.1875);
        }
        return new Vec3d(xDif > 0 ? 0.8125 : 0.1875, 0.4375, 0.5);
    }

    @Override
    public boolean isDummy() {
        return !this.lower;
    }

    @Override
    public boolean isLogicDummy() {
        return this.lower;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.field_145850_b.func_175656_a(pos.func_177982_a(0, 1, 0), state);
        ((TileEntityEnergyMeter)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)1, (int)0))).lower = false;
        ((TileEntityEnergyMeter)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)1, (int)0))).facing = this.facing;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, !this.lower ? -1 : 0, 0).func_177982_a(0, i, 0)) instanceof TileEntityEnergyMeter)) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, !this.lower ? -1 : 0, 0).func_177982_a(0, i, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAveragePower() {
        TileEntityEnergyMeter te = this;
        if (te.lower) {
            TileEntity tmp = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, 1, 0));
            if (!(tmp instanceof TileEntityEnergyMeter)) {
                return -1;
            }
            te = (TileEntityEnergyMeter)tmp;
        }
        if (te.lastPackets.size() == 0) {
            return 0;
        }
        int sum = 0;
        ArrayList<Integer> arrayList = te.lastPackets;
        synchronized (arrayList) {
            for (int transfer : te.lastPackets) {
                sum += transfer;
            }
        }
        return sum / te.lastPackets.size();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.1875, -0.625, 0.1875, 0.8125, 0.8125, 0.8125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        if (this.lower) {
            list.set(0, ((AxisAlignedBB)list.get(0)).func_72317_d(0.0, 1.0, 0.0));
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        }
        return list;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    private void updateComparatorValues() {
        int oldVal = this.compVal;
        int maxTrans = 0;
        Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
        if (conns == null) {
            this.compVal = 0;
        } else {
            for (ImmersiveNetHandler.Connection c : conns) {
                maxTrans += c.cableType.getTransferRate();
            }
            double val = (double)this.getAveragePower() / (double)(maxTrans /= 2);
            this.compVal = (int)Math.ceil(15.0 * val);
        }
        if (oldVal != this.compVal) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            this.field_145850_b.func_175666_e(this.field_174879_c.func_177977_b(), this.func_145838_q());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return this.compVal;
    }
}

