/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDevice1;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWoodenPost
extends TileEntityIEBase
implements IPostBlock,
IEBlockInterfaces.IFaceShape,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IHasObjProperty,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHammerInteraction {
    public static ArrayList<? extends Enum> postMetaProperties = Lists.newArrayList((Object[])new Enum[]{BlockTypes_WoodenDevice1.POST, BlockTypes_MetalDecoration2.ALUMINUM_POST, BlockTypes_MetalDecoration2.STEEL_POST});
    public byte dummy;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static ArrayList<String> emptyDisplayList = new ArrayList();

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.func_74771_c("dummy");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74774_a("dummy", this.dummy);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 4, 1));
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        if (this.dummy != 0) {
            return emptyDisplayList;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("base");
        for (int i = 0; i <= 2; ++i) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, 1 + i, 0));
            if (!(te instanceof TileEntityWoodenPost)) continue;
            for (EnumFacing f : EnumFacing.field_176754_o) {
                if (!((TileEntityWoodenPost)te).hasConnection(f)) continue;
                if (i == 2) {
                    TileEntityWoodenPost arm = (TileEntityWoodenPost)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1 + i, 0).func_177972_a(f));
                    boolean up = arm.hasConnection(EnumFacing.UP);
                    boolean down = arm.hasConnection(EnumFacing.DOWN);
                    if (up || !up && !down) {
                        list.add("arm_" + f.func_176742_j() + "_up");
                    }
                    if (!down) continue;
                    list.add("arm_" + f.func_176742_j() + "_down");
                    continue;
                }
                list.add("con_" + i + "_" + f.func_176742_j());
            }
        }
        return list;
    }

    @Override
    public BlockFaceShape getFaceShape(EnumFacing side) {
        if (this.dummy == 0) {
            return side == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
        }
        if (this.dummy >= 3) {
            return side == EnumFacing.UP || this.dummy > 3 && side == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.CENTER;
    }

    public boolean hasConnection(EnumFacing dir) {
        BlockPos pos = this.func_174877_v().func_177972_a(dir);
        if (this.dummy > 0 && this.dummy < 3) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            for (Enum enum_ : postMetaProperties) {
                if (!state.func_177228_b().containsValue((Object)enum_)) continue;
                return false;
            }
            AxisAlignedBB boundingBox = state.func_185900_c((IBlockAccess)this.field_145850_b, pos);
            double d = boundingBox.field_72340_a;
            double maxX = boundingBox.field_72336_d;
            double minZ = boundingBox.field_72339_c;
            double maxZ = boundingBox.field_72334_f;
            boolean connect = dir == EnumFacing.NORTH ? maxZ == 1.0 : (dir == EnumFacing.SOUTH ? minZ == 0.0 : (dir == EnumFacing.WEST ? maxX == 1.0 : d == 0.0));
            return connect && (dir.func_176740_k() == EnumFacing.Axis.Z && d > 0.0 && maxX < 1.0 || dir.func_176740_k() == EnumFacing.Axis.X && minZ > 0.0 && maxZ < 1.0);
        }
        if (this.dummy == 3) {
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            return te instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)te).dummy - 3 == dir.ordinal();
        }
        if (this.dummy > 3) {
            if (this.field_145850_b.func_175623_d(pos)) {
                return false;
            }
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            AxisAlignedBB boundingBox = state.func_185900_c((IBlockAccess)this.field_145850_b, pos);
            return dir == EnumFacing.UP ? boundingBox.field_72338_b == 0.0 : dir == EnumFacing.DOWN && boundingBox.field_72337_e == 1.0;
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        float down;
        if (this.dummy == 0) {
            return new float[]{0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f};
        }
        if (this.dummy <= 2) {
            return new float[]{this.hasConnection(EnumFacing.WEST) ? 0.0f : 0.375f, 0.0f, this.hasConnection(EnumFacing.NORTH) ? 0.0f : 0.375f, this.hasConnection(EnumFacing.EAST) ? 1.0f : 0.625f, 1.0f, this.hasConnection(EnumFacing.SOUTH) ? 1.0f : 0.625f};
        }
        if (this.dummy == 3) {
            return new float[]{this.hasConnection(EnumFacing.WEST) ? 0.0f : 0.3125f, 0.0f, this.hasConnection(EnumFacing.NORTH) ? 0.0f : 0.3125f, this.hasConnection(EnumFacing.EAST) ? 1.0f : 0.6875f, 1.0f, this.hasConnection(EnumFacing.SOUTH) ? 1.0f : 0.6875f};
        }
        float up = this.hasConnection(EnumFacing.UP) ? 1.0f : 0.5625f;
        float f = down = this.hasConnection(EnumFacing.DOWN) ? 0.0f : 0.4375f;
        if (down == 0.4375f && up == 0.5625f) {
            up = 1.0f;
        }
        if (this.dummy - 3 == 2) {
            return new float[]{0.3125f, down, 0.3125f, 0.6875f, up, 1.0f};
        }
        if (this.dummy - 3 == 3) {
            return new float[]{0.3125f, down, 0.0f, 0.6875f, up, 0.6875f};
        }
        if (this.dummy - 3 == 4) {
            return new float[]{0.3125f, down, 0.3125f, 1.0f, up, 0.6875f};
        }
        if (this.dummy - 3 == 5) {
            return new float[]{0.0f, down, 0.3125f, 0.6875f, up, 0.6875f};
        }
        return null;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 3; ++i) {
            this.field_145850_b.func_175656_a(pos.func_177982_a(0, i, 0), state);
            ((TileEntityWoodenPost)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)i, (int)0))).dummy = (byte)i;
            this.field_145850_b.func_175641_c(pos.func_177982_a(0, i, 0), this.func_145838_q(), 255, 0);
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (this.dummy <= 3) {
            for (int i = 0; i <= 3; ++i) {
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, (int)(-this.dummy), 0).func_177982_a(0, i, 0)) instanceof TileEntityWoodenPost) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, (int)(-this.dummy), 0).func_177982_a(0, i, 0));
                }
                if (i != 3) continue;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, (int)(-this.dummy), 0).func_177982_a(0, i, 0).func_177972_a(facing));
                    if (!(te instanceof TileEntityWoodenPost) || ((TileEntityWoodenPost)te).dummy != 3 + facing.ordinal()) continue;
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, (int)(-this.dummy), 0).func_177982_a(0, i, 0).func_177972_a(facing));
                }
            }
        }
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.dummy == 3 && side.func_176740_k() != EnumFacing.Axis.Y) {
            BlockPos offsetPos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175623_d(offsetPos)) {
                return false;
            }
            TileEntity perpendicular = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side.func_176746_e()));
            if (perpendicular instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)perpendicular).dummy - 3 == side.func_176746_e().ordinal()) {
                return false;
            }
            perpendicular = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side.func_176735_f()));
            if (perpendicular instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)perpendicular).dummy - 3 == side.func_176735_f().ordinal()) {
                return false;
            }
            this.field_145850_b.func_175656_a(offsetPos, this.field_145850_b.func_180495_p(this.func_174877_v()));
            ((TileEntityWoodenPost)this.field_145850_b.func_175625_s((BlockPos)offsetPos)).dummy = (byte)(3 + side.ordinal());
            this.markBlockForUpdate(offsetPos, null);
            this.markBlockForUpdate(this.func_174877_v().func_177982_a(0, -3, 0), null);
        } else if (this.dummy > 3) {
            EnumFacing f = EnumFacing.func_82600_a((int)(this.dummy - 3)).func_176734_d();
            this.field_145850_b.func_175698_g(this.func_174877_v());
            this.markBlockForUpdate(this.func_174877_v().func_177972_a(f).func_177982_a(0, -3, 0), null);
        }
        return false;
    }

    @Override
    public boolean canConnectTransformer(IBlockAccess world, BlockPos pos) {
        return this.dummy > 0 && this.dummy <= 3;
    }
}

