/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MetalPressPackingRecipe
extends MetalPressRecipe {
    private final int gridSize;
    private final int totalAmount;
    private final int baseEnergy;
    private HashMap<ComparableItemStack, PackedDelegate> cache = new HashMap();

    public MetalPressPackingRecipe(ComparableItemStack mold, int energy, int gridSize) {
        super(ItemStack.field_190927_a, ItemStack.field_190927_a, mold, energy);
        this.gridSize = gridSize;
        this.totalAmount = gridSize * gridSize;
        this.baseEnergy = energy;
        MetalPressRecipe.deserializers.put("packing" + this.totalAmount, nbt -> {
            ComparableItemStack comp = ComparableItemStack.readFromNBT(nbt.func_74775_l("mapKey"));
            if (this.cache.containsKey(comp)) {
                return this.cache.get(comp);
            }
            PackedDelegate delegate = new PackedDelegate(comp, new ItemStack(nbt.func_74775_l("output")), IngredientStack.readFromNBT(nbt.func_74775_l("input")), ComparableItemStack.readFromNBT(nbt.func_74775_l("mold")), nbt.func_74762_e("energy"));
            this.cache.put(comp, delegate);
            return delegate;
        });
    }

    @Override
    public boolean listInJEI() {
        return false;
    }

    @Override
    public boolean matches(ItemStack mold, ItemStack input) {
        return input.func_190916_E() >= this.totalAmount && this.getOutputCached(input) != null;
    }

    @Override
    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input) {
        return this.getOutputCached(input);
    }

    private PackedDelegate getOutputCached(ItemStack input) {
        ComparableItemStack comp = new ComparableItemStack(input);
        if (this.cache.containsKey(comp)) {
            return this.cache.get(comp);
        }
        comp.copy();
        ItemStack out = MetalPressPackingRecipe.getPackedOutput(this.gridSize, this.totalAmount, input);
        if (out.func_190926_b()) {
            this.cache.put(comp, null);
            return null;
        }
        PackedDelegate delegate = new PackedDelegate(comp, out, Utils.copyStackWithAmount(input, this.totalAmount), this.mold, this.baseEnergy);
        this.cache.put(comp, delegate);
        return delegate;
    }

    public static ItemStack getPackedOutput(int gridSize, int totalAmount, ItemStack stack) {
        InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)totalAmount, (Object)stack.func_77946_l()));
        IRecipe recipe = Utils.findRecipe(invC, FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_());
        if (recipe != null) {
            return recipe.func_77572_b(invC);
        }
        return ItemStack.field_190927_a;
    }

    public static class PackedDelegate
    extends MetalPressRecipe {
        private final ComparableItemStack mapKey;

        public PackedDelegate(ComparableItemStack mapKey, ItemStack output, Object input, ComparableItemStack mold, int energy) {
            super(output, input, mold, energy);
            this.mapKey = mapKey;
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("type", "packing" + this.input.inputSize);
            nbt.func_74782_a("mapKey", (NBTBase)this.mapKey.writeToNBT(new NBTTagCompound()));
            nbt.func_74782_a("output", (NBTBase)this.output.func_77955_b(new NBTTagCompound()));
            nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
            nbt.func_74782_a("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
            nbt.func_74768_a("energy", (int)((float)this.getTotalProcessEnergy() / energyModifier));
            return nbt;
        }
    }
}

