/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJerrycan
extends ItemIEBase {
    public ItemJerrycan() {
        super("jerrycan", 1, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            TextFormatting rarity = fs.getFluid().getRarity() == EnumRarity.COMMON ? TextFormatting.GRAY : fs.getFluid().getRarity().field_77937_e;
            list.add(rarity + fs.getLocalizedName() + TextFormatting.GRAY + ": " + fs.amount + "/" + 10000 + "mB");
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || !tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
            if (Utils.placeFluidBlock(world, pos.func_177972_a(side), fs)) {
                if (fs.amount <= 0) {
                    fs = null;
                }
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, "jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack) != null;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "jerrycanDrain")) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
            handler.drain(ItemNBTHelper.getInt(ret, "jerrycanDrain"), true);
            ItemNBTHelper.remove(ret, "jerrycanDrain");
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
            handler.drain(1000, true);
            return ret;
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, 10000);
    }
}

