/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttainedDropsHelper
extends IECompatModule {
    static HashMap<ComparableItemStack, ItemStack[]> soilOutputMap = new HashMap();
    static HashMap<ComparableItemStack, IBlockState> bulbMap = new HashMap();

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        Block blockPlant = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("attaineddrops:plant"));
        final Item itemSeed = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("attaineddrops:itemseed"));
        if (blockPlant == null || itemSeed == null) {
            return;
        }
        final IBlockState blockstatePlant = blockPlant.func_176223_P();
        IProperty propertyAge = null;
        for (IProperty prop : blockstatePlant.func_177227_a()) {
            if (!"age".equals(prop.func_177701_a()) || !(prop instanceof PropertyInteger)) continue;
            propertyAge = prop;
        }
        final IProperty propertyAge_final = propertyAge;
        AttainedDropsHelper.addType("slimeball", new ItemStack(Items.field_151123_aH));
        AttainedDropsHelper.addType("bone", new ItemStack(Items.field_151103_aS));
        AttainedDropsHelper.addType("string", new ItemStack(Items.field_151007_F));
        AttainedDropsHelper.addType("rottenflesh", new ItemStack(Items.field_151078_bh));
        AttainedDropsHelper.addType("ghasttear", new ItemStack(Items.field_151073_bk));
        AttainedDropsHelper.addType("spidereye", new ItemStack(Items.field_151070_bp));
        AttainedDropsHelper.addType("prismarine", new ItemStack(Items.field_179562_cC));
        AttainedDropsHelper.addType("blaze", new ItemStack(Items.field_151072_bj));
        AttainedDropsHelper.addType("gunpowder", new ItemStack(Items.field_151016_H));
        AttainedDropsHelper.addType("witherskull", new ItemStack(Items.field_151144_bL, 1, 1));
        AttainedDropsHelper.addType("enderpearl", new ItemStack(Items.field_151079_bi));
        BelljarHandler.registerHandler(new BelljarHandler.IPlantHandler(){

            @Override
            public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
                return !soil.func_190926_b() && soilOutputMap.containsKey(new ComparableItemStack(soil));
            }

            @Override
            public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
                return ((double)growth < 0.5 ? 0.003125f : 0.0015625f) * fertilizer;
            }

            @Override
            public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
                return 0.5f;
            }

            @Override
            public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
                ItemStack[] out = soilOutputMap.get(new ComparableItemStack(soil));
                if (out == null) {
                    return new ItemStack[0];
                }
                return out;
            }

            @Override
            public boolean isValid(ItemStack seed) {
                return !seed.func_190926_b() && seed.func_77973_b() == itemSeed;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return new IBlockState[0];
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return 0.875f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
                IBlockState state = blockstatePlant.func_177226_a(propertyAge_final, (Comparable)Integer.valueOf((double)growth >= 0.5 ? 7 : Math.min(7, Math.round(7.0f * growth * 2.0f))));
                IBakedModel model = blockRenderer.func_184389_a(state);
                GlStateManager.func_179094_E();
                blockRenderer.func_175019_b().func_178266_a(model, state, 1.0f, true);
                GlStateManager.func_179121_F();
                if ((double)growth >= 0.5) {
                    state = bulbMap.get(new ComparableItemStack(soil));
                    model = blockRenderer.func_184389_a(state);
                    GlStateManager.func_179094_E();
                    float scale = (growth - 0.5f) * 2.0f;
                    GlStateManager.func_179137_b((double)(0.5 - (double)(scale / 2.0f)), (double)1.0, (double)(-0.5 + (double)(scale / 2.0f)));
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    blockRenderer.func_175019_b().func_178266_a(model, state, 1.0f, true);
                    GlStateManager.func_179121_F();
                }
                return true;
            }
        });
    }

    static void addType(String type, ItemStack out) {
        Block soilBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("attaineddrops:" + type + "_soil"));
        Block bulbBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("attaineddrops:" + type + "_bulb"));
        if (soilBlock != null && bulbBlock != null) {
            ComparableItemStack comp = new ComparableItemStack(new ItemStack(soilBlock));
            soilOutputMap.put(comp, new ItemStack[]{out});
            bulbMap.put(comp, bulbBlock.func_176223_P());
        }
    }

    @Override
    public void postInit() {
    }
}

