/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.gui.GuiManual;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ManualInstance {
    public FontRenderer fontRenderer;
    public String texture;
    public ArrayListMultimap<String, ManualEntry> manualContents = ArrayListMultimap.create();
    public HashMap<Integer, ManualLink> itemLinks = Maps.newHashMap();

    public ManualInstance(FontRenderer fontRenderer, String texture) {
        this.fontRenderer = fontRenderer;
        this.texture = texture;
    }

    public abstract String getManualName();

    public abstract String[] getSortedCategoryList();

    public abstract String formatCategoryName(String var1);

    public abstract String formatEntryName(String var1);

    public abstract String formatEntrySubtext(String var1);

    public abstract String formatLink(ManualLink var1);

    public abstract String formatText(String var1);

    public abstract boolean showCategoryInList(String var1);

    public abstract boolean showEntryInList(ManualEntry var1);

    public abstract int getTitleColour();

    public abstract int getSubTitleColour();

    public abstract int getTextColour();

    public abstract int getHighlightColour();

    public abstract int getPagenumberColour();

    public abstract boolean allowGuiRescale();

    public abstract boolean improveReadability();

    public void openManual() {
    }

    public void closeManual() {
    }

    public void openEntry(String entry) {
    }

    public void titleRenderPre() {
    }

    public void titleRenderPost() {
    }

    public void entryRenderPre() {
    }

    public void entryRenderPost() {
    }

    public void tooltipRenderPre() {
    }

    public void tooltipRenderPost() {
    }

    public GuiManual getGui() {
        if (GuiManual.activeManual != null && GuiManual.activeManual.getManual() == this) {
            return GuiManual.activeManual;
        }
        return new GuiManual(this, this.texture);
    }

    public void addEntry(String name, String category, IManualPage ... pages) {
        this.manualContents.put((Object)category, (Object)new ManualEntry(name, category, pages));
    }

    public ManualEntry getEntry(String name) {
        for (ManualEntry e : this.manualContents.values()) {
            if (!e.name.equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public void indexRecipes() {
        this.itemLinks.clear();
        for (ManualEntry entry : this.manualContents.values()) {
            int iP = 0;
            for (IManualPage p : entry.getPages()) {
                p.recalculateCraftingRecipes();
                for (ItemStack s : p.getProvidedRecipes()) {
                    this.itemLinks.put(this.getItemHash(s), new ManualLink(entry.getName(), iP));
                }
                ++iP;
            }
        }
    }

    public ManualLink getManualLink(ItemStack stack) {
        int hash = this.getItemHash(stack);
        return this.itemLinks.get(hash);
    }

    int getItemHash(ItemStack stack) {
        return (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).hashCode() * 31 + (stack.func_77981_g() ? stack.func_77960_j() : 0)) * 31 + (!stack.func_77942_o() || stack.func_77978_p().func_82582_d() ? 0 : stack.func_77978_p().hashCode());
    }

    public static class ManualLink {
        private final String key;
        private final int page;

        public ManualLink(String key, int page) {
            this.key = key;
            this.page = page;
        }

        public String getKey() {
            return this.key;
        }

        public int getPage() {
            return this.page;
        }

        public void changePage(GuiManual guiManual) {
            guiManual.previousSelectedEntry.push(guiManual.getSelectedEntry());
            guiManual.setSelectedEntry(this.key);
            guiManual.page = this.page;
            guiManual.func_73866_w_();
        }
    }

    public static class ManualEntry {
        String name;
        String category;
        IManualPage[] pages;

        public ManualEntry(String name, String category, IManualPage ... pages) {
            this.name = name;
            this.category = category;
            this.pages = pages;
        }

        public String getName() {
            return this.name;
        }

        public String getCategory() {
            return this.category;
        }

        public IManualPage[] getPages() {
            return this.pages;
        }

        public void setPages(IManualPage[] pages) {
            this.pages = pages;
        }
    }
}

