/*
 * Decompiled with CFR 0.152.
 */
package com.flashoverride.simplebedrolls.block;

import com.flashoverride.simplebedrolls.SimpleBedrolls;
import com.flashoverride.simplebedrolls.config.ConfigHandler;
import com.flashoverride.simplebedrolls.tileentity.TileEntityBedroll;
import com.flashoverride.simplebedrolls.util.RegisterUtil;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBedroll
extends BlockHorizontal
implements ITileEntityProvider {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    public static EnumDyeColor color;
    private BlockPos spawnPos;
    protected static final AxisAlignedBB BEDROLL_AABB;

    public BlockBedroll() {
        super(Material.field_151580_n);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false)).func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
        this.field_149758_A = true;
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.1f);
        this.func_149663_c("simplebedrolls.bedroll");
        this.func_149649_H();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (state.func_177229_b(PART) == EnumPartType.FOOT && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityBedroll) {
            EnumDyeColor enumdyecolor = ((TileEntityBedroll)tileentity).getColor();
            return MapColor.func_193558_a((EnumDyeColor)enumdyecolor);
        }
        return MapColor.field_151659_e;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (state.func_177229_b(PART) != EnumPartType.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() != this) {
            return true;
        }
        if (worldIn.field_73011_w.func_76567_e() && worldIn.func_180494_b(pos) != Biomes.field_76778_j) {
            EntityPlayer.SleepResult entityplayer$sleepresult;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInBed(worldIn, pos);
                if (entityplayer != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                    return true;
                }
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 4);
            }
            if ((entityplayer$sleepresult = this.trySleep(worldIn, pos, playerIn)) == EntityPlayer.SleepResult.OK) {
                long worldTime;
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 4);
                playerIn.func_70999_a(false, true, false);
                playerIn.field_71081_bT = this.spawnPos;
                for (worldTime = 0L; worldTime < worldIn.func_72820_D(); worldTime += 24000L) {
                }
                worldIn.func_72877_b(worldTime);
                if (ConfigHandler.pickUpAfterSleep) {
                    EnumDyeColor enumdyecolor;
                    TileEntity tileentity = worldIn.func_175625_s(pos);
                    EnumDyeColor enumDyeColor = enumdyecolor = tileentity instanceof TileEntityBedroll ? ((TileEntityBedroll)tileentity).getColor() : EnumDyeColor.WHITE;
                    if (!playerIn.func_184812_l_() && !playerIn.func_191521_c(this.func_185473_a(worldIn, pos, state.func_177226_a(COLOR, (Comparable)enumdyecolor)))) {
                        BlockBedroll.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)RegisterUtil.BEDROLL, 1, enumdyecolor.func_176765_a()));
                    }
                    worldIn.func_175698_g(pos);
                    worldIn.func_175713_t(pos);
                    BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
                        worldIn.func_175698_g(blockpos);
                        worldIn.func_175713_t(blockpos);
                    }
                }
                return true;
            }
            if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.tooFarAway", new Object[0]), true);
            }
            return true;
        }
        worldIn.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        worldIn.func_72885_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x * 0.3300000131130219;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.4;
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(PART) == EnumPartType.FOOT ? Items.field_190931_a : RegisterUtil.BEDROLL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BEDROLL_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @Nullable
    public static BlockPos getSafeExitLocation(World worldIn, BlockPos pos, int tries) {
        EnumFacing enumfacing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)field_185512_D);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockBedroll.hasRoomForPlayer(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            EnumDyeColor enumdyecolor = tileentity instanceof TileEntityBedroll ? ((TileEntityBedroll)tileentity).getColor() : EnumDyeColor.WHITE;
            BlockBedroll.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)RegisterUtil.BEDROLL, 1, enumdyecolor.func_176765_a()));
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        BlockPos blockpos = pos;
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D));
        }
        EnumDyeColor enumdyecolor = (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityBedroll ? ((TileEntityBedroll)tileentity).getColor() : EnumDyeColor.WHITE;
        return new ItemStack((Item)RegisterUtil.BEDROLL, 1, enumdyecolor.func_176765_a());
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.FOOT && worldIn.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D))).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (state.func_177229_b(PART) == EnumPartType.HEAD && te instanceof TileEntityBedroll) {
            TileEntityBedroll tileentitybedroll = (TileEntityBedroll)te;
            ItemStack itemstack = tileentitybedroll.getItemStack();
            BlockBedroll.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf((meta & 4) > 0)) : this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity2;
        TileEntity tileentity = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        TileEntity tileEntity = tileentity2 = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d()), Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d()));
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
            if (iblockstate.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)OCCUPIED, iblockstate.func_177229_b((IProperty)OCCUPIED));
            }
            if (tileentity instanceof TileEntityBedroll) {
                TileEntityBedroll tileentitybedroll = (TileEntityBedroll)tileentity;
                state = state.func_177226_a(COLOR, (Comparable)tileentitybedroll.getColor());
            }
        } else if (tileentity2 instanceof TileEntityBedroll) {
            TileEntityBedroll tileentitybedroll = (TileEntityBedroll)tileentity2;
            state = state.func_177226_a(COLOR, (Comparable)tileentitybedroll.getColor());
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            i |= 8;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, PART, OCCUPIED, COLOR});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityBedroll tileEntityBedroll = new TileEntityBedroll();
        tileEntityBedroll.setColor(color);
        return tileEntityBedroll;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isHeadPiece(int metadata) {
        return (metadata & 8) != 0;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    @Nullable
    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityPlayer player) {
        if (world instanceof World) {
            return BlockBedroll.getSafeExitLocation((World)world, pos, 0);
        }
        return null;
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        if (world instanceof World) {
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177230_c().func_176221_a(state, world, pos);
            state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(occupied));
            ((World)world).func_180501_a(pos, state, 4);
        }
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return this.func_176221_a(world.func_180495_p(pos), world, pos).func_177229_b(PART) == EnumPartType.FOOT;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate;
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (state.func_177229_b(PART) == EnumPartType.FOOT && (iblockstate = world.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() == this) {
            state = state.func_177226_a((IProperty)OCCUPIED, iblockstate.func_177229_b((IProperty)OCCUPIED));
        }
        if (tileentity instanceof TileEntityBedroll) {
            TileEntityBedroll tileentitybedroll = (TileEntityBedroll)tileentity;
            state = state.func_177226_a(COLOR, (Comparable)tileentitybedroll.getColor());
        }
        return state;
    }

    public Block setUnlocalizedName(EnumDyeColor colorIn) {
        color = colorIn;
        this.func_149663_c(this.func_149739_a() + "." + colorIn.toString());
        return this;
    }

    public EntityPlayer.SleepResult trySleep(World worldIn, BlockPos bedLocation, EntityPlayer playerIn) {
        EntityPlayer.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((EntityPlayer)playerIn, (BlockPos)bedLocation);
        if (ret != null) {
            return ret;
        }
        EnumFacing enumfacing = (EnumFacing)playerIn.field_70170_p.func_180495_p(bedLocation).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        if (!playerIn.field_70170_p.field_72995_K) {
            if (playerIn.func_70608_bn() || !playerIn.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (!playerIn.field_70170_p.field_73011_w.func_76569_d()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            }
            if (playerIn.field_70170_p.func_72935_r() && ConfigHandler.respectDaylight) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
            if (!this.bedInRange(bedLocation, playerIn, enumfacing)) {
                return EntityPlayer.SleepResult.TOO_FAR_AWAY;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = playerIn.field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB((double)bedLocation.func_177958_n() - d0, (double)bedLocation.func_177956_o() - d1, (double)bedLocation.func_177952_p() - d0, (double)bedLocation.func_177958_n() + d0, (double)bedLocation.func_177956_o() + d1, (double)bedLocation.func_177952_p() + d0), (Predicate)new SleepEnemyPredicate(playerIn));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (playerIn.func_184218_aH()) {
            playerIn.func_184210_p();
        }
        playerIn.field_70177_z = enumfacing.func_176734_d().func_185119_l();
        try {
            RegisterUtil.spawnShoulderEntities.invoke((Object)playerIn, new Object[0]);
            RegisterUtil.setSize.invoke((Object)playerIn, Float.valueOf(0.2f), Float.valueOf(0.2f));
        }
        catch (IllegalAccessException e) {
            SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem putting player in bedroll", e);
        }
        catch (IllegalArgumentException e) {
            SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem putting player in bedroll", e);
        }
        catch (InvocationTargetException e) {
            SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem putting player in bedroll", e);
        }
        IBlockState state = null;
        if (playerIn.field_70170_p.func_175667_e(bedLocation)) {
            state = playerIn.field_70170_p.func_180495_p(bedLocation);
        }
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)playerIn.field_70170_p, bedLocation, (Entity)playerIn)) {
            float f1 = 0.5f + (float)enumfacing.func_82601_c() * 0.4f;
            float f = 0.5f + (float)enumfacing.func_82599_e() * 0.4f;
            try {
                RegisterUtil.setRenderOffsetForSleep.invoke((Object)playerIn, enumfacing);
            }
            catch (IllegalAccessException e) {
                SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem setting render offset for sleep", e);
            }
            catch (IllegalArgumentException e) {
                SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem setting render offset for sleep", e);
            }
            catch (InvocationTargetException e) {
                SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem setting render offset for sleep", e);
            }
            playerIn.func_70107_b((double)((float)bedLocation.func_177958_n() + f1), (double)((float)bedLocation.func_177956_o() + 0.375f), (double)((float)bedLocation.func_177952_p() + f));
        } else {
            playerIn.func_70107_b((double)((float)bedLocation.func_177958_n() + 0.5f), (double)((float)bedLocation.func_177956_o() + 0.375f), (double)((float)bedLocation.func_177952_p() + 0.5f));
        }
        try {
            RegisterUtil.sleeping.setBoolean(playerIn, true);
            RegisterUtil.sleepTimer.setInt(playerIn, 0);
        }
        catch (IllegalArgumentException e) {
            SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem putting player to sleep", e);
        }
        catch (IllegalAccessException e) {
            SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem putting player to sleep", e);
        }
        this.spawnPos = playerIn.field_71081_bT;
        playerIn.field_71081_bT = bedLocation;
        playerIn.field_70159_w = 0.0;
        playerIn.field_70181_x = 0.0;
        playerIn.field_70179_y = 0.0;
        if (!playerIn.field_70170_p.field_72995_K) {
            playerIn.field_70170_p.func_72854_c();
        }
        SPacketUseBed sleepPacket = new SPacketUseBed(playerIn, bedLocation);
        playerIn.func_184102_h().func_71218_a(playerIn.field_71093_bK).func_73039_n().func_151248_b((Entity)playerIn, (Packet)sleepPacket);
        ((EntityPlayerMP)playerIn).field_71135_a.func_147359_a((Packet)sleepPacket);
        return EntityPlayer.SleepResult.OK;
    }

    private boolean bedInRange(BlockPos pos, EntityPlayer player, EnumFacing facing) {
        if (Math.abs(player.field_70165_t - (double)pos.func_177958_n()) <= 3.0 && Math.abs(player.field_70163_u - (double)pos.func_177956_o()) <= 2.0 && Math.abs(player.field_70161_v - (double)pos.func_177952_p()) <= 3.0) {
            return true;
        }
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        return Math.abs(player.field_70165_t - (double)blockpos.func_177958_n()) <= 3.0 && Math.abs(player.field_70163_u - (double)blockpos.func_177956_o()) <= 2.0 && Math.abs(player.field_70161_v - (double)blockpos.func_177952_p()) <= 3.0;
    }

    static {
        BEDROLL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    }

    static class SleepEnemyPredicate
    implements Predicate<EntityMob> {
        private final EntityPlayer player;

        private SleepEnemyPredicate(EntityPlayer playerIn) {
            this.player = playerIn;
        }

        public boolean apply(@Nullable EntityMob p_apply_1_) {
            return p_apply_1_.func_191990_c(this.player);
        }
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

