/*
 * Decompiled with CFR 0.152.
 */
package com.flashoverride.simplebedrolls.config;

import com.flashoverride.simplebedrolls.SimpleBedrolls;
import com.flashoverride.simplebedrolls.proxy.CommonProxy;
import java.util.logging.Level;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static boolean respectDaylight;
    public static boolean respectDaylightDefault;
    public static boolean fixUncrafting;
    public static boolean fixUncraftingDefault;
    public static boolean pickUpAfterSleep;
    public static boolean pickUpAfterSleepDefault;

    public static void readConfig() {
        Configuration config = CommonProxy.config;
        try {
            config.load();
            ConfigHandler.init(config);
        }
        catch (Exception e1) {
            SimpleBedrolls.LOGGER.log(Level.WARNING, "Problem loading config file", e1);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void init(Configuration configFile) {
        respectDaylight = configFile.getBoolean("respectDaylight", "general", respectDaylightDefault, "Bedrolls can only be used at night" + Configuration.NEW_LINE + " [true, false]" + Configuration.NEW_LINE);
        fixUncrafting = configFile.getBoolean("fixUncraftingRecipe", "general", fixUncraftingDefault, "Create CraftTweaker script to fix recipes in jglrxavpok's Uncrafting Table" + Configuration.NEW_LINE + " [true, false]" + Configuration.NEW_LINE);
        pickUpAfterSleep = configFile.getBoolean("pickUpAfterSleep", "general", pickUpAfterSleepDefault, "Auto pick up bedroll after sleeping" + Configuration.NEW_LINE + " [true, false]" + Configuration.NEW_LINE);
    }

    static {
        respectDaylightDefault = true;
        fixUncraftingDefault = false;
        pickUpAfterSleepDefault = false;
    }
}

