/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.llor;

import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigManager {
    public Configuration file;
    public Property useSkyLight;
    public Property displayMode;
    public Property chunkRadius;
    public Property pollingInterval;
    public ArrayList<String> displayModeName = new ArrayList();
    public ArrayList<String> displayModeDesc = new ArrayList();

    public ConfigManager(File configDir) {
        this.file = new Configuration(new File(configDir, "LLOverlayReloaded.cfg"));
        this.displayModeName.add("Standard");
        this.displayModeName.add("Advanced");
        this.displayModeName.add("Minimal");
        this.displayModeDesc.add("Show green (safe) and red (spawnable) areas.");
        this.displayModeDesc.add("Show green (safe), red (always spawnable) and yellow (currently safe, but will be spawnable at night) areas.");
        this.displayModeDesc.add("Do not show green area. For other areas, use standard mode when not counting sky light, or advanced mode otherwise.");
        this.reload();
    }

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("llor")) {
            this.update();
        }
    }

    void reload() {
        this.file.load();
        String comment = "How to display numbers? (default: 0)";
        for (int i = 0; i < this.displayModeName.size(); ++i) {
            comment = comment + "\n" + String.valueOf(i) + " - ";
            comment = comment + this.displayModeName.get(i) + ": ";
            comment = comment + this.displayModeDesc.get(i);
        }
        this.useSkyLight = this.file.get("general", "useSkyLight", false, "If set to true, the sunlight/moonlight will be counted in light level. (default: false)");
        this.displayMode = this.file.get("general", "displayMode", 0, comment);
        this.chunkRadius = this.file.get("general", "chunkRadius", 3, "The distance (in chunks) of rendering radius. (default: 3)");
        this.pollingInterval = this.file.get("general", "pollingInterval", 200, "The update interval (in milliseconds) of light level. Farther chunks update less frequently. (default: 200)");
        this.update();
    }

    public void update() {
        this.useSkyLight.set(this.useSkyLight.getBoolean(false));
        this.displayMode.set(Math.min(Math.max(this.displayMode.getInt(0), 0), this.displayModeName.size() - 1));
        this.chunkRadius.set(Math.min(Math.max(this.chunkRadius.getInt(3), 1), 9));
        this.pollingInterval.set(Math.min(Math.max(this.pollingInterval.getInt(200), 10), 60000));
        this.file.save();
    }
}

