/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.helpers.ModelCache;
import jds.bibliocraft.items.ItemWaypointCompass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelAtlas
implements IBakedModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:AtlasBook");
    private IBakedModel baseModel;
    private IBakedModel simpleAtlas;
    List<String> simpleParts;
    List<String> modelParts;
    IModel model = null;
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IBakedModel wrapper;
    private ModelCache cache;
    private float needle = 1.0f;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };

    public ModelAtlas(IBakedModel model) {
        this.baseModel = model;
        this.modelParts = new ArrayList<String>();
        this.modelParts.add("book");
        this.modelParts.add("compass");
        this.modelParts.add("1");
        this.simpleParts = new ArrayList<String>();
        this.simpleParts.add("book");
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    private boolean checkForMatchingCompass(NBTTagCompound tags, int compass) {
        NBTTagList tagList = tags.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack invStack;
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= 6 || (invStack = new ItemStack(tag)) == null || !(invStack.func_77973_b() instanceof ItemWaypointCompass) || compass != slot) continue;
            return true;
        }
        return false;
    }

    private int getCompassNeedlePart(float needleAngle) {
        while (needleAngle < 0.0f) {
            needleAngle += 360.0f;
        }
        while (needleAngle > 360.0f) {
            needleAngle -= 360.0f;
        }
        int result = 36 - (int)(needleAngle /= 10.0f);
        return result;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(ModelRotation.X0_Y90);
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.64f, 0.1f, 0.2f), new Quat4f(18.0f, 0.0f, 7.0f, 1.0f), new Vector3f(0.8f, 0.8f, 0.8f), new Quat4f(-1.1f, 0.0f, 0.1f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.5f, 2.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 2.0f, 0.0f, 1.0f)));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.1f, 0.1f, 0.5f), new Quat4f(18.0f, 0.0f, 7.0f, 1.0f), new Vector3f(0.8f, 0.8f, 0.8f), new Quat4f(-1.1f, 0.0f, 0.1f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(-0.5f, -2.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, -2.0f, 0.0f, 1.0f)));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(-0.66f, 0.05f, 0.5f), new Quat4f(1.0f, -1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, -0.2f, 0.06f, 0.5f));
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.25f, 0.15f, 0.25f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.5f, 0.24f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.baseModel != null) {
            return this.baseModel.func_188616_a(state, side, rand);
        }
        ArrayList<BakedQuad> blankList = new ArrayList<BakedQuad>();
        return blankList;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            int compass;
            if (ModelAtlas.this.simpleAtlas == null || ModelAtlas.this.simpleAtlas != null && !ModelAtlas.this.simpleAtlas.toString().contains("obj.OBJModel")) {
                try {
                    ModelAtlas.this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/atlas.obj"));
                    ModelAtlas.this.model = ModelAtlas.this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                    ModelAtlas.this.gotOBJ = true;
                }
                catch (Exception e) {
                    ModelAtlas.this.model = ModelLoaderRegistry.getMissingModel();
                    ModelAtlas.this.gotOBJ = false;
                }
                TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                OBJModel.OBJState partList = new OBJModel.OBJState(ModelAtlas.this.simpleParts, true, (IModelState)transform);
                ModelAtlas.this.simpleAtlas = ModelAtlas.this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, ModelAtlas.this.textureGetter);
            }
            ModelAtlas.this.baseModel = ModelAtlas.this.simpleAtlas;
            NBTTagCompound tags = stack.func_77978_p();
            if (tags != null && tags.func_74764_b("needleAngle") && tags.func_74764_b("savedCompass") && (compass = tags.func_74762_e("savedCompass")) != -1 && ModelAtlas.this.checkForMatchingCompass(tags, compass)) {
                ModelAtlas.this.modelParts = new ArrayList<String>();
                ModelAtlas.this.modelParts.add("book");
                ModelAtlas.this.modelParts.add("compass");
                String part = "" + ModelAtlas.this.getCompassNeedlePart(tags.func_74760_g("needleAngle") + 90.0f);
                ModelAtlas.this.modelParts.add(part);
                try {
                    ModelAtlas.this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/atlas.obj"));
                }
                catch (Exception e) {
                    ModelAtlas.this.model = ModelLoaderRegistry.getMissingModel();
                }
                ModelAtlas.this.model = ModelAtlas.this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                OBJModel.OBJState partList = new OBJModel.OBJState(ModelAtlas.this.modelParts, true, (IModelState)transform);
                if (ModelAtlas.this.cache.hasModel(part)) {
                    ModelAtlas.this.baseModel = ModelAtlas.this.cache.getCurrentMatch();
                } else {
                    IBakedModel bakedModel = ModelAtlas.this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, ModelAtlas.this.textureGetter);
                    if (ModelAtlas.this.gotOBJ) {
                        ModelAtlas.this.cache.addToCache(bakedModel, part);
                    }
                    ModelAtlas.this.baseModel = bakedModel;
                }
            }
            return ModelAtlas.this.wrapper;
        }
    }
}

