/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.helpers.ModelCache;
import jds.bibliocraft.items.ItemClipboard;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class ModelClipboard
implements IBakedModel {
    private IModel model = null;
    private IBakedModel baseModel;
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:Clipboard");
    public static final ModelResourceLocation clipboardBasicModel = new ModelResourceLocation("bibliocraft:clipboardsimple");
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IBakedModel wrapper;
    private FontRenderer textRender;
    private ModelCache cache;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("bibliocraft:models/clipboard");
        }
    };

    public ModelClipboard() {
        this.textRender = Minecraft.func_71410_x().field_71466_p;
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    private void getModel(IBlockState state, ItemStack stack) {
        IBakedModel bakedModel;
        if (this.model == null || this.model != null && !this.model.toString().contains("obj.OBJModel")) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:block/clipboard.obj"));
                this.model = this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                this.gotOBJ = true;
            }
            catch (Exception e) {
                this.model = ModelLoaderRegistry.getMissingModel();
                this.gotOBJ = false;
            }
        }
        OBJModel.OBJState modelState = new OBJModel.OBJState((List)Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"}), true);
        if (state != null && state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            if (exState.getUnlistedNames().contains(OBJModel.OBJProperty.INSTANCE)) {
                modelState = (OBJModel.OBJState)exState.getValue((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE);
                this.baseModel = bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, this.textureGetter);
            }
            if (modelState == null) {
                return;
            }
        }
        if (state == null && stack.func_77973_b() == ItemClipboard.instance) {
            String cacheName = "clipboard" + this.getModelPartsNumberString(stack);
            if (this.cache.hasModel(cacheName)) {
                this.baseModel = this.cache.getCurrentMatch();
            } else {
                modelState = new OBJModel.OBJState(this.getModelParts(stack), true);
                bakedModel = this.model.bake((IModelState)new OBJModel.OBJState(this.getModelParts(stack), true), DefaultVertexFormats.field_176599_b, this.textureGetter);
                if (this.gotOBJ) {
                    this.cache.addToCache(bakedModel, cacheName);
                }
                this.baseModel = bakedModel;
            }
        }
    }

    private String getModelPartsNumberString(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        String value = "";
        if (tags != null) {
            int[] states;
            int currentPage = tags.func_74762_e("currentPage");
            int totalPages = tags.func_74762_e("totalPages");
            String pagenum = "page" + currentPage;
            NBTTagCompound pagetag = tags.func_74775_l(pagenum);
            if (pagetag != null && (states = pagetag.func_74759_k("taskStates")) != null && states.length == 9) {
                for (int i = 0; i < states.length; ++i) {
                    value = value + states[i];
                }
            }
        }
        return value;
    }

    public List<String> getModelParts(ItemStack stack) {
        ArrayList<String> modelParts = new ArrayList<String>();
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            int[] states;
            int currentPage = tags.func_74762_e("currentPage");
            int totalPages = tags.func_74762_e("totalPages");
            String pagenum = "page" + currentPage;
            NBTTagCompound pagetag = tags.func_74775_l(pagenum);
            if (pagetag != null && (states = pagetag.func_74759_k("taskStates")) != null && states.length == 9) {
                switch (states[0]) {
                    case 1: {
                        modelParts.add("box1c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box1x");
                    }
                }
                switch (states[1]) {
                    case 1: {
                        modelParts.add("box2c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box2x");
                    }
                }
                switch (states[2]) {
                    case 1: {
                        modelParts.add("box3c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box3x");
                    }
                }
                switch (states[3]) {
                    case 1: {
                        modelParts.add("box4c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box4x");
                    }
                }
                switch (states[4]) {
                    case 1: {
                        modelParts.add("box5c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box5x");
                    }
                }
                switch (states[5]) {
                    case 1: {
                        modelParts.add("box6c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box6x");
                    }
                }
                switch (states[6]) {
                    case 1: {
                        modelParts.add("box7c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box7x");
                    }
                }
                switch (states[7]) {
                    case 1: {
                        modelParts.add("box8c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box8x");
                    }
                }
                switch (states[8]) {
                    case 1: {
                        modelParts.add("box9c");
                        break;
                    }
                    case 2: {
                        modelParts.add("box9x");
                    }
                }
            }
        }
        modelParts.add("Clipboard");
        return modelParts;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.05f, 0.25f, 0.3f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.3f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.2f, 0.4f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.2f, 0.4f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.35f, 0.15f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        this.getModel(state, ItemStack.field_190927_a);
        if (this.baseModel != null) {
            List q = this.baseModel.func_188616_a(state, side, rand);
            if (q != null) {
                return q;
            }
            return new ArrayList<BakedQuad>();
        }
        ArrayList<BakedQuad> blankList = new ArrayList<BakedQuad>();
        return blankList;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            ModelClipboard.this.getModel(null, stack);
            return ModelClipboard.this.wrapper;
        }
    }
}

