/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.helpers.ModelCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelCompass
implements IBakedModel {
    private IBakedModel baseModel;
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:compass");
    private List<String> modelParts;
    private IModel model = null;
    private final TRSRTransformation emptyTransform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IBakedModel wrapper;
    private ModelCache cache;
    private int needle = 0;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(ModelCompass.this.getTextureString());
        }
    };

    public ModelCompass(IBakedModel model) {
        this.baseModel = model;
        this.modelParts = new ArrayList<String>();
        this.modelParts.add("face");
        this.modelParts.add("1");
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    public String getTextureString() {
        return "bibliocraft:models/waypointcompass";
    }

    private static int getCompassNeedlePart(float needleAngle) {
        while (needleAngle < 0.0f) {
            needleAngle += 360.0f;
        }
        while (needleAngle > 360.0f) {
            needleAngle -= 360.0f;
        }
        int result = 36 - (int)(needleAngle /= 10.0f);
        return result;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(ModelRotation.X0_Y90);
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.45f, 0.75f, -0.5f), new Quat4f(-2.5f, 8.0f, 0.7f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(-0.0f, 0.45f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(-0.1f, 0.0f, 0.0f, 1.0f)));
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.0f, 1.0f, -0.3f), new Quat4f(-2.5f, 8.0f, 0.7f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(-0.0f, -0.45f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f)));
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.3f, -0.12f, 0.4f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.8f, 0.8f, 0.8f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.45f, -0.1f, 0.25f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.8f, 0.8f, 0.8f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(-0.95f, -0.0f, 0.5f), new Quat4f(1.1f, -1.0f, -0.9f, 1.0f), new Vector3f(1.3f, 1.3f, 1.3f), new Quat4f(0.0f, -0.2f, 0.06f, 0.5f));
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.33f, 0.1f, 0.33f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.64f, 0.64f, 0.64f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.5f, 0.5f, -0.45f), new Quat4f(-1.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.baseModel != null) {
            return this.baseModel.func_188616_a(state, side, rand);
        }
        ArrayList<BakedQuad> blankList = new ArrayList<BakedQuad>();
        return blankList;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            NBTTagCompound tags = stack.func_77978_p();
            if (tags != null && tags.func_74764_b("needleAngle")) {
                float needleAngle = tags.func_74760_g("needleAngle");
                int angle = ModelCompass.getCompassNeedlePart(needleAngle + 90.0f);
                ModelCompass.this.needle = angle;
                ModelCompass.this.modelParts = new ArrayList();
                ModelCompass.this.modelParts.add("face");
                ModelCompass.this.modelParts.add("" + angle);
            }
            if (ModelCompass.this.model == null || ModelCompass.this.model != null && !ModelCompass.this.model.toString().contains("obj.OBJModel")) {
                try {
                    ModelCompass.this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/compass.obj"));
                    ModelCompass.this.model = ModelCompass.this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                    ModelCompass.this.gotOBJ = true;
                }
                catch (Exception e) {
                    ModelCompass.this.model = ModelLoaderRegistry.getMissingModel();
                    ModelCompass.this.gotOBJ = false;
                }
            }
            Function<ResourceLocation, TextureAtlasSprite> texture = ModelCompass.this.textureGetter;
            OBJModel.OBJState partList = new OBJModel.OBJState(ModelCompass.this.modelParts, true, (IModelState)ModelCompass.this.emptyTransform);
            if (ModelCompass.this.cache.hasModel(texture.toString() + ModelCompass.this.needle)) {
                ModelCompass.this.baseModel = ModelCompass.this.cache.getCurrentMatch();
            } else {
                IBakedModel bakedModel = ModelCompass.this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, texture);
                if (ModelCompass.this.gotOBJ) {
                    ModelCompass.this.cache.addToCache(bakedModel, texture.toString() + ModelCompass.this.needle);
                }
                ModelCompass.this.baseModel = bakedModel;
            }
            return ModelCompass.this.wrapper;
        }
    }
}

