/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import teamroots.roots.book.Book;
import teamroots.roots.book.BookRegistry;
import teamroots.roots.book.Page;
import teamroots.roots.util.Misc;
import teamroots.roots.util.RenderUtil;

public class GuiBook
extends GuiScreen {
    String bookName = "";
    ItemStack bookItem = ItemStack.field_190927_a;
    public double mouseX = 0.0;
    public double mouseY = 0.0;
    public double smoothMouseX = 0.0;
    public double smoothMouseY = 0.0;
    public int contentsPage = -1;
    public boolean showLeftArrow = false;
    public boolean showRightArrow = false;
    public int tooltipX = 0;
    public int tooltipY = 0;
    ItemStack tooltipStack = null;
    public boolean renderTooltip = false;
    public int framesExisted = 0;

    public GuiBook(String name, ItemStack book) {
        this.bookName = name;
        this.bookItem = book;
    }

    public void markTooltipForRender(ItemStack stack, int x, int y) {
        this.renderTooltip = true;
        this.tooltipX = x;
        this.tooltipY = y;
        this.tooltipStack = stack;
    }

    public void doRenderTooltip() {
        if (this.renderTooltip) {
            this.func_146285_a(this.tooltipStack, this.tooltipX, this.tooltipY);
            this.renderTooltip = false;
        }
    }

    public void renderItemStackAt(ItemStack stack, int x, int y, int mouseX, int mouseY) {
        if (stack != ItemStack.field_190927_a) {
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_175042_a(stack, x, y);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, stack.func_190916_E() != 1 ? Integer.toString(stack.func_190916_E()) : "");
            if (mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
                this.markTooltipForRender(stack, mouseX, mouseY);
            }
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179140_f();
    }

    public void renderItemStackMinusTooltipAt(ItemStack stack, int x, int y, int mouseX, int mouseY) {
        if (stack != ItemStack.field_190927_a) {
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_175042_a(stack, x, y);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, stack.func_190916_E() != 1 ? Integer.toString(stack.func_190916_E()) : "");
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179140_f();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        float basePosX = (float)this.field_146294_l / 2.0f - 96.0f;
        float basePosY = (float)this.field_146295_m / 2.0f - 128.0f;
        Book book = BookRegistry.books.get(this.bookName);
        Page page = book.pages.get(book.selectedPage);
        if (this.showLeftArrow && (float)mouseX >= basePosX + 16.0f && (float)mouseY >= basePosY + 224.0f && (float)mouseX <= basePosX + 48.0f && (float)mouseY <= basePosY + 240.0f) {
            --book.selectedPage;
        }
        if (this.showRightArrow && (float)mouseX >= basePosX + 144.0f && (float)mouseY >= basePosY + 224.0f && (float)mouseX <= basePosX + 176.0f && (float)mouseY <= basePosY + 240.0f) {
            ++book.selectedPage;
        }
        if (this.contentsPage != -1 && (float)mouseX >= basePosX + 80.0f && (float)mouseY >= basePosY + 224.0f && (float)mouseX <= basePosX + 112.0f && (float)mouseY <= basePosY + 240.0f) {
            book.selectedPage = this.contentsPage;
        }
        if (page.type == Page.EnumPageType.TABLE_OF_CONTENTS && book.selectedPage < book.pages.size() - 1) {
            int ic = 0;
            for (int i = book.selectedPage; i < book.pages.size(); ++i) {
                if (book.pages.get((int)i).pageIcon == ItemStack.field_190927_a) continue;
                if ((float)mouseX >= basePosX + 17.0f + (float)(ic % 4 * 42) && (float)mouseY >= basePosY + 48.0f + (float)(ic / 4 * 28) && (float)mouseX <= basePosX + 49.0f + (float)(ic % 4 * 42) && (float)mouseY <= basePosY + 80.0f + (float)(ic / 4 * 28)) {
                    book.selectedPage = i;
                }
                ++ic;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        ArrayList<String> strings;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        Book book = BookRegistry.books.get(this.bookName);
        Page page = book.pages.get(book.selectedPage);
        boolean satisfiesReqs = true;
        if (page.doesReqKnowledge) {
            satisfiesReqs = Book.getKnowledge(this.bookItem) >= page.reqKnowledge;
        }
        this.contentsPage = -1;
        for (int i2 = 0; i2 < book.pages.size(); ++i2) {
            if (book.pages.get((int)i2).type != Page.EnumPageType.TABLE_OF_CONTENTS) continue;
            this.contentsPage = i2;
        }
        this.showLeftArrow = book.selectedPage != 0;
        this.showRightArrow = book.selectedPage < book.pages.size() - 1;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("roots:textures/gui/gui_book.png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int basePosX = (int)((float)this.field_146294_l / 2.0f) - 96;
        int basePosY = (int)((float)this.field_146295_m / 2.0f) - 128;
        this.func_73729_b(basePosX, basePosY, 0, 0, 192, 256);
        if (satisfiesReqs) {
            RenderUtil.drawCenteredString(this.field_146289_q, I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".title"), (Object[])new Object[0]), basePosX + 96, basePosY + 20, 0x2B2B2A);
        } else {
            RenderUtil.drawCenteredString(this.field_146289_q, I18n.func_135052_a((String)"roots.book.unknown_title", (Object[])new Object[0]), basePosX + 96, basePosY + 20, 0x2B2B2A);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("roots:textures/gui/gui_book.png"));
        if (page.type == Page.EnumPageType.TEXT && satisfiesReqs) {
            strings = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings.get(i), basePosX + 20, basePosY + 48 + 12 * i, 0x2B2B2A);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (page.type == Page.EnumPageType.DISPLAY && satisfiesReqs) {
            this.func_73729_b(basePosX + 84, basePosY + 52, 192, 48, 24, 24);
            this.renderItemStackAt(page.displayStack, basePosX + 88, basePosY + 56, mouseX, mouseY);
            strings = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings.get(i), basePosX + 20, basePosY + 80 + 12 * i, 0x2B2B2A);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (page.type == Page.EnumPageType.MORTAR && satisfiesReqs) {
            this.func_73729_b(basePosX + 84, basePosY + 68, 192, 96, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 116, 224, 72, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 140, 192, 48, 24, 24);
            this.renderItemStackAt(page.mortarOutput, basePosX + 88, basePosY + 144, mouseX, mouseY);
            for (int i3 = 0; i3 < page.mortarInputs.length; ++i3) {
                double angle = (double)i3 / (double)page.mortarInputs.length * 2.0 * Math.PI;
                this.renderItemStackAt(page.mortarInputs[i3], basePosX + 88 + (int)(24.0 * Math.cos(angle)), basePosY + 72 + (int)(24.0 * Math.sin(angle)), mouseX, mouseY);
            }
            strings = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings.get(i), basePosX + 20, basePosY + 166 + 12 * i, 0x2B2B2A);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (page.type == Page.EnumPageType.TABLE_OF_CONTENTS && book.selectedPage < book.pages.size() - 1) {
            int ic = 0;
            for (i = book.selectedPage; i < book.pages.size(); ++i) {
                if (book.pages.get((int)i).pageIcon == ItemStack.field_190927_a) continue;
                if (mouseX >= basePosX + 17 + ic % 4 * 42 && mouseY >= basePosY + 52 + ic / 4 * 28 && mouseX <= basePosX + 49 + ic % 4 * 42 && mouseY <= basePosY + 80 + ic / 4 * 28) {
                    this.func_73729_b(basePosX + 17 + ic % 4 * 42, basePosY + 72 + ic / 4 * 28, 192, 40, 32, 8);
                } else {
                    this.func_73729_b(basePosX + 17 + ic % 4 * 42, basePosY + 72 + ic / 4 * 28, 192, 32, 32, 8);
                }
                ++ic;
            }
            ic = 0;
            for (i = book.selectedPage; i < book.pages.size(); ++i) {
                if (book.pages.get((int)i).pageIcon == ItemStack.field_190927_a) continue;
                boolean bookReqs = book.pages.get(i).enoughKnowledge(this.bookItem);
                if (bookReqs) {
                    this.renderItemStackMinusTooltipAt(book.pages.get((int)i).pageIcon.func_151001_c(I18n.func_135052_a((String)("roots.book." + book.name + "." + book.pages.get((int)i).name + ".title"), (Object[])new Object[0])), basePosX + 25 + ic % 4 * 42, basePosY + 56 + ic / 4 * 28, mouseX, mouseY);
                    if (mouseX >= basePosX + 17 + ic % 4 * 42 && mouseY >= basePosY + 52 + ic / 4 * 28 && mouseX <= basePosX + 49 + ic % 4 * 42 && mouseY <= basePosY + 80 + ic / 4 * 28) {
                        this.markTooltipForRender(new ItemStack(Items.field_151055_y).func_151001_c(I18n.func_135052_a((String)("roots.book." + book.name + "." + book.pages.get((int)i).name + ".title"), (Object[])new Object[0])), mouseX, mouseY);
                    }
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("roots:textures/gui/gui_book.png"));
                    this.func_73729_b(basePosX + 17 + ic % 4 * 42, basePosY + 56 + ic / 4 * 28, 192, 176, 32, 16);
                    if (mouseX >= basePosX + 17 + ic % 4 * 42 && mouseY >= basePosY + 52 + ic / 4 * 28 && mouseX <= basePosX + 49 + ic % 4 * 42 && mouseY <= basePosY + 80 + ic / 4 * 28) {
                        this.markTooltipForRender(new ItemStack(Items.field_151055_y).func_151001_c(I18n.func_135052_a((String)"roots.book.more_knowledge", (Object[])new Object[0])), mouseX, mouseY);
                    }
                }
                ++ic;
            }
        }
        if (page.type == Page.EnumPageType.MOONLIGHT && satisfiesReqs) {
            this.func_73729_b(basePosX + 84, basePosY + 68, 192, 48, 24, 24);
            this.func_73729_b(basePosX + 132, basePosY + 68, 224, 96, 24, 24);
            this.func_73729_b(basePosX + 36, basePosY + 68, 224, 96, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 116, 224, 72, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 140, 192, 48, 24, 24);
            this.renderItemStackAt(page.moonlightOutput, basePosX + 88, basePosY + 144, mouseX, mouseY);
            this.renderItemStackAt(page.moonlightInputs[0], basePosX + 88, basePosY + 72, mouseX, mouseY);
            for (int i4 = 1; i4 < page.moonlightInputs.length; ++i4) {
                double angle = (double)i4 / (double)(page.moonlightInputs.length - 1) * 2.0 * Math.PI;
                this.renderItemStackAt(page.moonlightInputs[i4], basePosX + 88 + (int)(24.0 * Math.cos(angle)), basePosY + 72 + (int)(24.0 * Math.sin(angle)), mouseX, mouseY);
            }
            ArrayList<String> strings2 = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings2.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings2.get(i), basePosX + 20, basePosY + 166 + 12 * i, 0x2B2B2A);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (page.type == Page.EnumPageType.RITUAL && satisfiesReqs) {
            this.func_73729_b(basePosX + 84, basePosY + 68, 192, 192, 24, 24);
            for (int i5 = 0; i5 < page.ritualInputs.length; ++i5) {
                double angle = (double)i5 / (double)page.ritualInputs.length * 2.0 * Math.PI;
                this.renderItemStackAt(page.ritualInputs[i5], basePosX + 88 + (int)(24.0 * Math.cos(angle)), basePosY + 72 + (int)(24.0 * Math.sin(angle)), mouseX, mouseY);
            }
            ArrayList<String> strings3 = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings3.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings3.get(i), basePosX + 20, basePosY + 116 + 12 * i, 0x2B2B2A);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (page.type == Page.EnumPageType.CRAFTING && satisfiesReqs) {
            int j;
            int i6;
            for (i6 = 0; i6 < 3; ++i6) {
                for (j = 0; j < 3; ++j) {
                    this.func_73729_b(basePosX + 60 + 24 * i6, basePosY + 48 + 24 * j, 192, 48, 24, 24);
                }
            }
            this.func_73729_b(basePosX + 84, basePosY + 122, 224, 72, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 146, 192, 48, 24, 24);
            this.renderItemStackAt(page.craftingOutput, basePosX + 88, basePosY + 150, mouseX, mouseY);
            for (i6 = 0; i6 < 3; ++i6) {
                for (j = 0; j < 3; ++j) {
                    this.renderItemStackAt(page.craftingInputs[j * 3 + i6], basePosX + 64 + i6 * 24, basePosY + 52 + j * 24, mouseX, mouseY);
                }
            }
            ArrayList<String> strings4 = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings4.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings4.get(i), basePosX + 20, basePosY + 176 + 12 * i, 0x2B2B2A);
            }
        }
        if (page.type == Page.EnumPageType.FURNACE && satisfiesReqs) {
            this.func_73729_b(basePosX + 60, basePosY + 52, 192, 48, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 52, 224, 24, 24, 24);
            this.func_73729_b(basePosX + 84, basePosY + 76, 224, 48, 24, 24);
            this.func_73729_b(basePosX + 108, basePosY + 52, 192, 48, 24, 24);
            this.renderItemStackAt(page.furnaceInput, basePosX + 64, basePosY + 56, mouseX, mouseY);
            this.renderItemStackAt(page.furnaceOutput, basePosX + 112, basePosY + 56, mouseX, mouseY);
            ArrayList<String> strings5 = Misc.getLines(I18n.func_135052_a((String)("roots.book." + book.name + "." + page.name + ".desc"), (Object[])new Object[0]), 160);
            for (i = 0; i < strings5.size(); ++i) {
                this.field_146289_q.func_78276_b((String)strings5.get(i), basePosX + 20, basePosY + 104 + 12 * i, 0x2B2B2A);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("roots:textures/gui/gui_book.png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.showLeftArrow) {
            if (mouseX >= basePosX + 16 && mouseY >= basePosY + 224 && mouseX <= basePosX + 48 && mouseY <= basePosY + 240) {
                this.func_73729_b(basePosX + 16, basePosY + 224, 224, 144, 32, 16);
            } else {
                this.func_73729_b(basePosX + 16, basePosY + 224, 224, 128, 32, 16);
            }
        }
        if (this.showRightArrow) {
            if (mouseX >= basePosX + 144 && mouseY >= basePosY + 224 && mouseX <= basePosX + 176 && mouseY <= basePosY + 240) {
                this.func_73729_b(basePosX + 144, basePosY + 224, 192, 144, 32, 16);
            } else {
                this.func_73729_b(basePosX + 144, basePosY + 224, 192, 128, 32, 16);
            }
        }
        if (this.contentsPage != -1) {
            if (mouseX >= basePosX + 80 && mouseY >= basePosY + 224 && mouseX <= basePosX + 112 && mouseY <= basePosY + 240) {
                this.func_73729_b(basePosX + 80, basePosY + 224, 224, 160, 32, 16);
            } else {
                this.func_73729_b(basePosX + 80, basePosY + 224, 192, 160, 32, 16);
            }
        }
        this.doRenderTooltip();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179118_c();
    }
}

