/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.world;

import java.util.Random;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSand;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.roots.ley.LeyLineNoiseGen;
import teamroots.roots.world.StructureBase;

public class WorldGenLeyMarker
extends StructureBase
implements IWorldGenerator {
    public WorldGenLeyMarker() {
        super(3, 3);
        this.addBlockMapping("M", Blocks.field_150341_Y.func_176223_P());
        this.addBlockMapping("C", Blocks.field_150347_e.func_176223_P());
        this.addBlockMapping("W", Blocks.field_150463_bK.func_176223_P());
        this.addBlockMapping(" ", Blocks.field_150350_a.func_176223_P());
        this.addBlockMapping("L", Blocks.field_150368_y.func_176223_P());
        this.addLayer(new String[]{"MMM", "MMM", "MMM"});
        this.addLayer(new String[]{"CMM", "CCM", "MMC"});
        this.addLayer(new String[]{" M ", "MMC", " M "});
        this.addLayer(new String[]{" M ", "CCM", " M "});
        this.addLayer(new String[]{" M ", "CCC", " C "});
        this.addLayer(new String[]{" M ", "CCM", " M "});
        this.addLayer(new String[]{" C ", "MCC", " C "});
        this.addLayer(new String[]{" C ", "CCC", " C "});
        this.addLayer(new String[]{"CC ", "CCC", " CC"});
        this.addLayer(new String[]{"C C", " L ", "C C"});
        this.addLayer(new String[]{" CC", "C C", "CC "});
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos leyPos;
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a() && (leyPos = LeyLineNoiseGen.getNearestLeyLine(world, new BlockPos(chunkX * 16, 0, chunkZ * 16))).func_177956_o() > 0 && leyPos.func_177958_n() >= chunkX * 16 && leyPos.func_177952_p() >= chunkZ * 16 && leyPos.func_177958_n() < chunkX * 16 + 16 && leyPos.func_177952_p() < chunkZ * 16 + 16) {
            boolean generated = false;
            for (int i = 0; i < 8 && !generated; ++i) {
                double ang = random.nextDouble() * 360.0;
                int offX = (int)(8.0 * Math.sin(Math.toRadians(ang)));
                int offZ = (int)(8.0 * Math.cos(Math.toRadians(ang)));
                BlockPos placePos = new BlockPos(leyPos.func_177958_n() + offX, leyPos.func_177956_o() - 1, leyPos.func_177952_p() + offZ);
                if (!(world.func_180495_p(placePos).func_177230_c() instanceof BlockGrass) && !(world.func_180495_p(placePos).func_177230_c() instanceof BlockSand)) continue;
                this.generateIn(world, placePos.func_177958_n(), placePos.func_177956_o() - 1, placePos.func_177952_p());
                generated = true;
            }
        }
    }
}

