/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.client.gui;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import the_fireplace.overlord.container.ContainerConvertedSkeleton;
import the_fireplace.overlord.entity.EntityConvertedSkeleton;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.network.packets.AttackModeMessage;
import the_fireplace.overlord.network.packets.MovementModeMessage;
import the_fireplace.overlord.network.packets.RequestAugmentMessage;
import the_fireplace.overlord.network.packets.SetSquadMessage;
import the_fireplace.overlord.tools.ArmyUtils;

public class GuiConvertedSkeleton
extends GuiContainer {
    public static final ResourceLocation texture = new ResourceLocation("overlord", "textures/gui/converted_skeleton.png");
    private EntityConvertedSkeleton entity;
    private GuiButton attackMode;
    private byte attackModeTimer;
    private GuiButton movementMode;
    private byte movementModeTimer;
    private ArrayList<String> squads;
    private int squadIndex;

    public GuiConvertedSkeleton(InventoryPlayer inventorySlotsIn, EntityConvertedSkeleton warrior, ArrayList<String> squads) {
        super((Container)new ContainerConvertedSkeleton(inventorySlotsIn, warrior));
        this.entity = warrior;
        this.field_146999_f = 175;
        this.field_147000_g = 165;
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = res.func_78326_a();
        this.field_146295_m = res.func_78328_b();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.squads = squads;
        this.squadIndex = squads.indexOf(warrior.getSquad());
    }

    public void func_73866_w_() {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = res.func_78326_a();
        this.field_146295_m = res.func_78328_b();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.attackMode = new GuiButton(0, this.field_147003_i + 47, this.field_147009_r + 43, 66, 20, "You should not see this");
        this.field_146292_n.add(this.attackMode);
        this.movementMode = new GuiButton(1, this.field_147003_i + 47, this.field_147009_r + 63, 66, 20, "You should not see this");
        this.field_146292_n.add(this.movementMode);
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 25, this.field_147009_r + 23, 20, 20, "<-"));
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 94, this.field_147009_r + 23, 20, 20, "->"));
        this.setAttackModeText();
        this.setMovementModeText();
        super.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                PacketDispatcher.sendToServer(new AttackModeMessage(this.entity));
                this.setAttackModeText();
                this.scheduleAttackModeTextUpdate();
            } else if (button.field_146127_k == 1) {
                PacketDispatcher.sendToServer(new MovementModeMessage(this.entity));
                this.setMovementModeText();
                this.scheduleMovementModeTextUpdate();
            } else if (button.field_146127_k == 2) {
                this.squadIndex = this.squadIndex < 0 ? this.squads.size() - 1 : --this.squadIndex;
            } else if (button.field_146127_k == 3) {
                this.squadIndex = this.squadIndex >= this.squads.size() - 1 ? -1 : ++this.squadIndex;
            }
            if (this.squadIndex > -1) {
                PacketDispatcher.sendToServer(new SetSquadMessage(this.entity, this.squads.get(this.squadIndex)));
            } else {
                PacketDispatcher.sendToServer(new SetSquadMessage(this.entity, ""));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.field_147003_i + 47, this.field_147009_r + 8, 0, 166, (int)(this.entity.func_110143_aJ() / this.entity.func_110138_aP() * 90.0f), 5);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.func_73732_a(this.field_146289_q, (int)Math.ceil(this.entity.func_110143_aJ()) + "/" + (int)Math.ceil(this.entity.func_110138_aP()), 90, 4, Color.RED.getRGB());
        this.func_73732_a(this.field_146289_q, this.squadIndex != -1 ? this.squads.get(this.squadIndex) : I18n.func_135052_a((String)"overlord.no_squad", (Object[])new Object[0]), 70, 30, -1);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        if (this.attackModeTimer > 0) {
            this.attackModeTimer = (byte)(this.attackModeTimer - 1);
        }
        if (this.attackModeTimer == 1) {
            this.setAttackModeText();
        }
        if (this.movementModeTimer > 0) {
            this.movementModeTimer = (byte)(this.movementModeTimer - 1);
        }
        if (this.movementModeTimer == 1) {
            this.setMovementModeText();
        }
        super.func_73876_c();
        if (!this.entity.func_70089_S() || this.entity.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void setAttackModeText() {
        this.attackMode.field_146126_j = ArmyUtils.getAttackModeString(this.entity.getAttackMode());
    }

    public void setMovementModeText() {
        this.movementMode.field_146126_j = ArmyUtils.getMovementModeString(this.entity.getMovementMode());
    }

    public void scheduleAttackModeTextUpdate() {
        this.attackModeTimer = (byte)5;
    }

    public void scheduleMovementModeTextUpdate() {
        this.movementModeTimer = (byte)5;
    }

    public void func_146281_b() {
        if (this.entity.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new RequestAugmentMessage(this.entity));
        }
        super.func_146281_b();
    }
}

